/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.collection.IsIterableContainingInOrder.contains;
import static org.hamcrest.core.IsNull.nullValue;
import static org.mule.tooling.client.internal.hamcrest.HamcrestUtils.validateThat;

import org.mule.tooling.client.api.extension.model.source.SourceCallbackModel;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class SourceCallbackMatcher extends TypeSafeDiagnosingMatcher<SourceCallbackModel> {

  public static Matcher<SourceCallbackModel> from(org.mule.runtime.api.meta.model.source.SourceCallbackModel runtimeCallbackModel) {
    if (runtimeCallbackModel == null) {
      return nullValue(SourceCallbackModel.class);
    }
    return new SourceCallbackMatcher(runtimeCallbackModel);
  }

  private final org.mule.runtime.api.meta.model.source.SourceCallbackModel runtimeCallbackModel;

  private SourceCallbackMatcher(org.mule.runtime.api.meta.model.source.SourceCallbackModel runtimeCallbackModel) {
    this.runtimeCallbackModel = runtimeCallbackModel;
  }

  @Override
  protected boolean matchesSafely(SourceCallbackModel item, Description mismatchDescription) {
    return validateThat("name", item.getName(), equalTo(runtimeCallbackModel.getName()), mismatchDescription) &&
        validateThat("description", item.getDescription(), equalTo(runtimeCallbackModel.getDescription()), mismatchDescription) &&
        (runtimeCallbackModel.getParameterGroupModels().isEmpty()
            ? validateThat("parameterGroupModels", item.getParameterGroupModels(), hasSize(0), mismatchDescription)
            : validateThat("parameterGroupModels", item.getParameterGroupModels(),
                           contains(ParameterGroupMatcher.sFrom(runtimeCallbackModel.getParameterGroupModels())),
                           mismatchDescription))
        &&
        runtimeCallbackModel
            .getDisplayModel()
            .map(rdm -> item.getDisplayModel()
                .map(dm -> validateThat("displayModel", dm, DisplayModelMatcher.from(rdm), mismatchDescription))
                .orElse(false))
            .orElseGet(() -> validateThat("displayModel", item.getDisplayModel(), nullValue(), mismatchDescription));
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("SourceCallbackModel: ").appendValue(runtimeCallbackModel);
  }
}
