/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.session.filter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.module.tooling.internal.artifact.params.ParameterSimpleValueExtractor;
import org.mule.tooling.client.internal.session.filter.FilterUtils;
import org.mule.tooling.client.internal.session.filter.exception.MissingLevelException;
import org.mule.tooling.client.internal.session.filter.exception.UnknownLevelValueException;

public class MetadataKeyFilter {
    public Set<MetadataKey> filter(String parameterName, ParameterizedElementDeclaration parameterizedElementDeclaration, Set<MetadataKey> metadataKeys) {
        HashMap<String, Set<MetadataKey>> metadataKeysByPart = new HashMap<String, Set<MetadataKey>>();
        try {
            this.filterMetadataKeys(metadataKeysByPart, metadataKeys, parameterizedElementDeclaration);
        }
        catch (MissingLevelException e) {
            Set level = (Set)metadataKeysByPart.get(parameterName);
            if (level == null) {
                throw e;
            }
            return level;
        }
        return Collections.emptySet();
    }

    private void filterMetadataKeys(Map<String, Set<MetadataKey>> metadataKeysByPart, Set<MetadataKey> metadataKeys, ParameterizedElementDeclaration parameterizedElementDeclaration) {
        Optional<String> optionalKeyPart = metadataKeys.stream().findFirst().map(MetadataKey::getPartName);
        if (!optionalKeyPart.isPresent()) {
            return;
        }
        String keyPart = optionalKeyPart.get();
        metadataKeysByPart.put(keyPart, metadataKeys);
        Optional<String> optionalKeyPartConfiguredValue = FilterUtils.getParameterConfiguredValue(parameterizedElementDeclaration, keyPart).map(ParameterSimpleValueExtractor::extractSimpleValue);
        if (!optionalKeyPartConfiguredValue.isPresent()) {
            throw new MissingLevelException(keyPart);
        }
        String keyPartConfiguredValue = optionalKeyPartConfiguredValue.get();
        Optional<MetadataKey> matchingKey = metadataKeys.stream().filter(k -> k.getId().equals(keyPartConfiguredValue)).findFirst();
        if (!matchingKey.isPresent()) {
            throw new UnknownLevelValueException(keyPart, keyPartConfiguredValue);
        }
        this.filterMetadataKeys(metadataKeysByPart, matchingKey.get().getChilds(), parameterizedElementDeclaration);
    }
}

