/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.utils;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueResult;
import org.mule.tooling.client.api.value.resolver.ResolvedValue;
import org.mule.tooling.client.api.value.resolver.ValueResolverFailure;
import org.mule.tooling.client.api.value.resolver.ValueResolverResult;

public class ValueResolverUtils {
    public static ValueResolverResult toValueResolverResult(ValueResult valueResult) {
        if (valueResult.isSuccess()) {
            return ValueResolverResult.success(ValueResolverUtils.toResolvedValues(valueResult.getValues()));
        }
        return ValueResolverResult.failure((ValueResolverFailure)ValueResolverUtils.toValueResolvedFailure(valueResult.getFailure()));
    }

    public static Set<ResolvedValue> toResolvedValues(Set<Value> values) {
        return values.stream().map(ValueResolverUtils::toResolvedValue).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static ValueResolverResult toValueResolverResult(Set<MetadataKey> metadataKeys) {
        return ValueResolverResult.success((Set)metadataKeys.stream().map(ValueResolverUtils::toResolvedValue).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    private static ResolvedValue toResolvedValue(MetadataKey metadataKey) {
        return new ResolvedValue(metadataKey.getId(), metadataKey.getDisplayName());
    }

    private static ResolvedValue toResolvedValue(Value value) {
        return new ResolvedValue(value.getId(), value.getDisplayName());
    }

    private static ValueResolverFailure toValueResolvedFailure(Optional<ResolvingFailure> resolvingFailureOptional) {
        return resolvingFailureOptional.map(r -> new ValueResolverFailure(r.getMessage(), r.getReason(), r.getFailureCode())).orElse(null);
    }
}

