/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.dataweave;

import static java.util.Objects.requireNonNull;
import org.mule.tooling.client.internal.application.RemoteDomainInvoker;

import com.mulesoft.agent.domain.tooling.dataweave.model.PreviewRequest;
import com.mulesoft.agent.domain.tooling.dataweave.model.PreviewResponse;

/**
 * {@link DataWeaveRunner} remote runner implementation for domains.
 *
 * @since 4.1
 */
public class DomainRemoteRunner extends AbstractRemoteRunner {

  private RemoteDomainInvoker remoteDomainInvoker;

  /**
   * Creates an instance of the domain runner.
   *
   * @param remoteDomainInvoker the invoker to call Mule Runtime service. Non null.
   */
  public DomainRemoteRunner(RemoteDomainInvoker remoteDomainInvoker) {
    requireNonNull(remoteDomainInvoker, "remoteDomainInvoker cannot be null");

    this.remoteDomainInvoker = remoteDomainInvoker;
  }

  @Override
  protected PreviewResponse doExecute(PreviewRequest request) {
    return remoteDomainInvoker.evaluateWithRemoteDomain((domainId, runtimeToolingService) -> runtimeToolingService
        .runDataWeaveDomain(domainId, request));
  }
}
