/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session;

import static java.util.Optional.ofNullable;
import static java.util.function.Function.identity;
import static java.util.stream.Collectors.toMap;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * Provides a way to retrieve a {@link ConfigurationElementDeclaration} by refname from within the
 * {@link org.mule.tooling.client.api.declaration.session.DeclarationSession}
 */
public class ConfigurationDeclarationProvider {

  private final Map<String, ConfigurationElementDeclaration> configsMap;

  public ConfigurationDeclarationProvider(List<ConfigurationElementDeclaration> configurationElementDeclarations) {
    configsMap =
        configurationElementDeclarations.stream().collect(toMap(ConfigurationElementDeclaration::getRefName, identity()));
  }

  public Optional<ConfigurationElementDeclaration> getConfigDeclaration(String configName) {
    return ofNullable(configsMap.get(configName));
  }

}
