/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session;

import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.api.util.LazyValue;

import java.util.Optional;
import java.util.Set;

/**
 * Implementation that lazily creates an adapted {@link DslResolvingContext} in order to avoid resolving extension models if we
 * don't need to.
 */
public class LazyDslResolvingContext implements DslResolvingContext {

  private final ExtensionModelProvider extensionModelProvider;
  private final LazyValue<DslResolvingContext> lazyValueDelegate;

  public LazyDslResolvingContext(ExtensionModelProvider extensionModelProvider) {
    this.extensionModelProvider = extensionModelProvider;
    this.lazyValueDelegate = new LazyValue<>(() -> DslResolvingContext.getDefault(extensionModelProvider.getAll()));
  }

  @Override
  public Optional<ExtensionModel> getExtension(String name) {
    return lazyValueDelegate.get().getExtension(name);
  }

  @Override
  public Optional<ExtensionModel> getExtensionForType(String typeId) {
    return lazyValueDelegate.get().getExtensionForType(typeId);
  }

  @Override
  public Set<ExtensionModel> getExtensions() {
    return lazyValueDelegate.get().getExtensions();
  }

  @Override
  public TypeCatalog getTypeCatalog() {
    return lazyValueDelegate.get().getTypeCatalog();
  }
}
