/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import static org.hamcrest.CoreMatchers.nullValue;

import org.mule.tooling.client.api.extension.model.ExternalLibraryType;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ExternalLibraryTypeMatcher extends TypeSafeMatcher<ExternalLibraryType> {

  public static Matcher<ExternalLibraryType> from(org.mule.runtime.api.meta.ExternalLibraryType runtimeExternalType) {
    if (runtimeExternalType == null) {
      return nullValue(ExternalLibraryType.class);
    }
    return new ExternalLibraryTypeMatcher(runtimeExternalType);
  }

  private final org.mule.runtime.api.meta.ExternalLibraryType runtimeExternalType;

  private ExternalLibraryTypeMatcher(org.mule.runtime.api.meta.ExternalLibraryType runtimeExternalType) {
    this.runtimeExternalType = runtimeExternalType;
  }

  @Override
  protected boolean matchesSafely(ExternalLibraryType item) {
    switch (runtimeExternalType) {
      case JAR:
        return item.isJar();
      case NATIVE:
        return item.isNativeLibrary();
      case DEPENDENCY:
        return item.isDependency();
    }
    return false;
  }

  @Override
  protected void describeMismatchSafely(ExternalLibraryType item, Description mismatchDescription) {
    mismatchDescription.appendText("was ExternalLibraryType: ").appendValue(item);
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("ExternalLibraryType: ").appendValue(runtimeExternalType);
  }
}
