/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.AetherMavenClientProvider;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.container.api.ContainerClassLoaderProvider;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.deployment.model.api.artifact.DescriptorLoaderRepositoryFactory;
import org.mule.runtime.globalconfig.api.maven.MavenClientFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.service.api.discoverer.ServiceProviderDiscoverer;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;
import org.mule.runtime.module.service.internal.artifact.ServiceClassLoaderFactory;
import org.mule.runtime.module.service.internal.discoverer.DefaultServiceDiscoverer;
import org.mule.runtime.module.service.internal.discoverer.FileSystemServiceProviderDiscoverer;
import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.ToolingRuntimeClientBuilderFactory;
import org.mule.tooling.client.internal.ApplicationCache;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.DefaultToolingRuntimeClientBuilder;
import org.mule.tooling.client.internal.DomainCache;
import org.mule.tooling.client.internal.ExtensionModelServiceCache;
import org.mule.tooling.client.internal.dsl.DslSyntaxServiceCache;
import org.mule.tooling.client.internal.log4j.ToolingLog4jContextFactory;
import org.mule.tooling.client.internal.serialization.KryoServerSerializer;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.serialization.XStreamServerSerializer;
import org.mule.tooling.client.internal.service.DefaultServiceRegistry;
import org.mule.tooling.client.internal.service.ServiceRegistry;
import org.mule.tooling.client.internal.util.Preconditions;

public class DefaultToolingRuntimeClientFactory
implements ToolingRuntimeClientBuilderFactory,
Command,
Disposable {
    private static final String TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_DISABLE = "tooling.client.ExtensionModelServiceCache.disable";
    private static final String SERVICES_FOLDER = "services";
    private final String toolingVersion;
    private ArtifactClassLoader containerClassLoaderFactory;
    private ModuleRepository moduleRepository;
    private Optional<ExtensionModelServiceCache> extensionModelServiceCache = Optional.empty();
    private ApplicationCache applicationCache;
    private DomainCache domainCache;
    private DslSyntaxServiceCache dslSyntaxServiceCache;
    private LazyValue<Serializer> serializer = new LazyValue(() -> new XStreamServerSerializer(this.getToolingAPIClassLoader()));
    private File workingDirectory;
    private boolean deleteWorkingDirectoryOnDispose = false;
    private ServiceRegistry serviceRegistry;

    public DefaultToolingRuntimeClientFactory(String toolingVersion) {
        this(toolingVersion, DefaultToolingRuntimeClientFactory.createTemporaryWorkingDirectory());
    }

    private static File createTemporaryWorkingDirectory() {
        File workingDirectory = Files.createTempDir();
        workingDirectory.deleteOnExit();
        return workingDirectory;
    }

    public DefaultToolingRuntimeClientFactory(String toolingVersion, File workingDirectory) {
        this.preInitialize();
        this.toolingVersion = toolingVersion;
        if (workingDirectory != null) {
            this.workingDirectory = workingDirectory;
        } else {
            this.workingDirectory = DefaultToolingRuntimeClientFactory.createTemporaryWorkingDirectory();
            this.deleteWorkingDirectoryOnDispose = true;
        }
        if (!Boolean.valueOf(System.getProperty(TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_DISABLE, "false")).booleanValue()) {
            this.extensionModelServiceCache = Optional.of(new ExtensionModelServiceCache(toolingVersion));
        }
        this.initialise();
    }

    private void preInitialize() {
        try {
            XmlObject.Factory.parse((String)"<example>data</example>");
        }
        catch (XmlException e) {
            throw new IllegalStateException("Could not pre initialize XmlBeans library", e);
        }
    }

    private void initialise() {
        this.moduleRepository = ModuleRepository.createModuleRepository((ClassLoader)DefaultToolingRuntimeClientFactory.class.getClassLoader(), (File)this.workingDirectory);
        this.containerClassLoaderFactory = ContainerClassLoaderProvider.createContainerClassLoader((ModuleRepository)this.moduleRepository, (ClassLoader)DefaultToolingRuntimeClientFactory.class.getClassLoader());
        this.applicationCache = new ApplicationCache();
        this.domainCache = new DomainCache();
        this.dslSyntaxServiceCache = new DslSyntaxServiceCache();
        this.discoverServices();
    }

    private void discoverServices() {
        File servicesFolder = new File(this.workingDirectory, SERVICES_FOLDER);
        List serviceJarFiles = Arrays.stream(((URLClassLoader)this.getClass().getClassLoader()).getURLs()).map(url -> org.apache.commons.io.FileUtils.toFile((URL)url)).filter(file -> file.getName().endsWith("mule-service.jar")).collect(Collectors.toList());
        serviceJarFiles.stream().forEach(serviceJarFile -> {
            try {
                FileUtils.unzip((File)serviceJarFile, (File)new File(servicesFolder, serviceJarFile.getName()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        MavenClientFactory.setMavenClientProvider(() -> new AetherMavenClientProvider(){

            public MavenClient createMavenClient(MavenConfiguration mavenConfiguration) {
                return null;
            }
        });
        DescriptorLoaderRepository descriptorLoaderRepository = new DescriptorLoaderRepositoryFactory().createDescriptorLoaderRepository();
        FileSystemServiceProviderDiscoverer fileSystemServiceProviderDiscoverer = new FileSystemServiceProviderDiscoverer(this.containerClassLoaderFactory, (ArtifactClassLoaderFactory)new ServiceClassLoaderFactory(), descriptorLoaderRepository, ArtifactDescriptorValidatorBuilder.builder(), servicesFolder);
        try {
            this.serviceRegistry = new DefaultServiceRegistry(new DefaultServiceDiscoverer((ServiceProviderDiscoverer)fileSystemServiceProviderDiscoverer).discoverServices());
        }
        catch (ServiceResolutionError serviceResolutionError) {
            throw new IllegalStateException(serviceResolutionError);
        }
    }

    public void setSerialization(String name) {
        Preconditions.checkState((boolean)this.getSupportedSerialization().contains(name), (String)String.format("Not supported serialization '%s', the ones supported by this implementation are: %s", name, this.getSupportedSerialization()));
        if (XStreamServerSerializer.NAME.equals(name)) {
            this.serializer = new LazyValue(() -> new XStreamServerSerializer(this.getToolingAPIClassLoader()));
        } else if (KryoServerSerializer.NAME.equals(name)) {
            this.serializer = new LazyValue(() -> new KryoServerSerializer(this.getClass().getClassLoader(), this.getToolingAPIClassLoader()));
        }
    }

    private ClassLoader getToolingAPIClassLoader() {
        return this.getClass().getClassLoader().getParent().getParent();
    }

    private List<String> getSupportedSerialization() {
        return ImmutableList.builder().add((Object[])new String[]{XStreamServerSerializer.NAME, KryoServerSerializer.NAME}).build();
    }

    public ToolingRuntimeClient.Builder create() {
        return new DefaultToolingRuntimeClientBuilder(this.toolingVersion, (Serializer)this.serializer.get(), this.moduleRepository, this.containerClassLoaderFactory, this.extensionModelServiceCache, this.applicationCache, this.domainCache, this.dslSyntaxServiceCache, this.serviceRegistry, this.workingDirectory);
    }

    public void dispose() {
        this.extensionModelServiceCache.ifPresent(service -> this.dispose((Disposable)service));
        this.dispose(this.domainCache);
        this.dispose(this.applicationCache);
        this.dispose(this.dslSyntaxServiceCache);
        if (LogManager.getFactory() instanceof ToolingLog4jContextFactory) {
            ((ToolingLog4jContextFactory)LogManager.getFactory()).dispose();
        }
        if (this.serviceRegistry != null) {
            this.serviceRegistry.dispose();
        }
        if (this.deleteWorkingDirectoryOnDispose) {
            org.apache.commons.io.FileUtils.deleteQuietly((File)this.workingDirectory);
        }
    }

    private void dispose(Disposable disposable) {
        try {
            disposable.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "dispose": {
                this.dispose();
                return null;
            }
            case "create": {
                return this.create();
            }
        }
        throw new IllegalArgumentException(String.format("Invalid arguments passed for calling method '%s' on '%s'", methodName, this.getClass()));
    }
}

