/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.metadata.api.locator.ComponentLocator;
import org.mule.tooling.client.api.value.provider.ValueProviderRequest;
import org.mule.tooling.client.internal.application.RemoteApplicationInvoker;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.values.ValueProviderCache;

import java.util.List;
import java.util.function.Supplier;

/**
 * Implementation for retrieving value providers for applications.
 *
 * @since 4.1
 */
public class ApplicationValueProviderService extends AbstractValueProviderService {

  private RemoteApplicationInvoker remoteApplicationInvoker;

  /**
   * Creates an instance of this service.
   *
   * @param remoteApplicationInvoker {@link RemoteApplicationInvoker} to retrieve values for an Application from Mule Runtime. Non
   *                                 null.
   */
  public ApplicationValueProviderService(RemoteApplicationInvoker remoteApplicationInvoker,
                                         Supplier<List<ExtensionModel>> extensionModelsSupplier,
                                         Serializer serializer,
                                         LazyValue<ValueProviderCache> valueProvidersCache,
                                         LazyValue<? extends ComponentLocator<ComponentAst>> locator) {
    super(extensionModelsSupplier, serializer, valueProvidersCache, locator);
    this.remoteApplicationInvoker = remoteApplicationInvoker;
  }

  @Override
  protected ValueResult doGetValue(ValueProviderRequest valueProviderRequest) {
    return remoteApplicationInvoker.evaluateWithRemoteApplication((applicationId,
                                                                   runtimeToolingService) -> runtimeToolingService
                                                                       .getValuesApplication(applicationId,
                                                                                             valueProviderRequest
                                                                                                 .getLocation(),
                                                                                             valueProviderRequest
                                                                                                 .getProviderName()));

  }
}
