/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.application;

import org.mule.tooling.agent.RuntimeToolingService;

/**
 * Invokes operations on a Mule Runtime domain.
 *
 * @since 4.0
 */
public interface RemoteDomainInvoker {

  /**
   * Evaluates the given function in the context of a remote domain from Mule Runtime. If the domain has not been deployed yet, it
   * will deploy it first and then call the function with the generated domainId that is passed to the function as parameter.
   * <p/>
   * If the application was already deployed as there was cached an domainId but the function throws a
   * {@link org.mule.tooling.client.api.exception.NoSuchApplicationException} it will do a deploy and invoke the function.
   *
   * @param function to be executed against a deployed domain.
   * @param <R>      the type for the result of the function.
   * @return a result of type {@code <R>}
   */
  <R> R evaluateWithRemoteDomain(DomainRemoteFunction<R> function);

  /**
   * A function that receives the domainId from the domain deploy on Mule Runtime and the service to invoke operations remotely on
   * Mule Runtime.
   *
   * @param <R> type of the result for this function.
   */
  @FunctionalInterface
  interface DomainRemoteFunction<R> {

    /**
     * Applies a remote operation to an domain deployed on Mule Runtime using a {@link RuntimeToolingService}.
     *
     * @param domainId the id for the domain deployed on Mule Runtime.
     * @return the function result
     */
    R apply(String domainId, RuntimeToolingService runtimeToolingService);

  }

}
