/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session.cache;

import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.app.declaration.api.ElementDeclaration;

import java.util.concurrent.Callable;

/**
 * Cache used to improve performance while resolving {@link Value}s based on an {@link ElementDeclaration}.
 *
 * @since 4.4.0
 */
public interface DeclarationValueProviderCache {

  /**
   * Gets the possible values for the given parameter belonging to the {@link ElementDeclaration}, if not present the
   * {@link Callable} should be called and result stored in order to resolve the values.
   *
   * @param elementDeclaration parameter container element
   * @param parameterName      name of the parameter to resolves values from
   * @param callable           resolution logic if values not present
   * @param forceResolution    call the resolver even if there is a value stored in the cache and override it with * the new
   *                           result
   * @return {@link ValueResult} with the requested information
   */
  ValueResult getValues(ElementDeclaration elementDeclaration,
                        String parameterName,
                        Callable<ValueResult> callable,
                        boolean forceResolution);

  /**
   * Gets the possible values for the given field(targetSelector) in the given parameter belonging to the
   * {@link ElementDeclaration}, if not present the {@link Callable} should be called and result stored in order to resolve the
   * values.
   *
   * @param elementDeclaration parameter container element
   * @param parameterName      name of the parameter to resolves values from
   * @param targetSelector     the selector to locate the field within the parameter
   * @param callable           resolution logic if values not present
   * @param forceResolution    call the resolver even if there is a value stored in the cache and override it with * the new
   *                           result
   * @return {@link ValueResult} with the requested information
   */
  ValueResult getValues(ElementDeclaration elementDeclaration,
                        String parameterName,
                        String targetSelector,
                        Callable<ValueResult> callable,
                        boolean forceResolution);

}
