/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session.filter.exception;

/**
 * Exception to be thrown when filtering a MultiLevel result and the values given are invalid. Either because they are of a
 * different type than expected or an expression fails to resolve.
 */
public class InvalidLevelValueException extends RuntimeException {

  private final String targetSelector;

  public InvalidLevelValueException(String targetSelector, Throwable cause) {
    super(cause);
    this.targetSelector = targetSelector;
  }

  public String getTargetSelector() {
    return targetSelector;
  }
}
