/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.utils;

import org.mule.tooling.client.api.exception.ToolingException;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

/**
 * Utility class for IO operations.
 */
public final class IOUtils {

  public static InputStream readContentFromUrl(URL url, int connectTimeout, int readTimeout) {
    try {
      URLConnection urlConnection = url.openConnection();
      urlConnection.setDefaultUseCaches(false);

      urlConnection.setConnectTimeout(connectTimeout);
      urlConnection.setReadTimeout(readTimeout);
      return new BufferedInputStream(urlConnection.getInputStream());
    } catch (Exception e) {
      throw new ToolingException("Error while reading content from URL: " + url, e);
    }
  }


}
