/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.values;

import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.api.dsl.model.DslElementModelFactory;
import org.mule.runtime.metadata.api.dsl.DslElementModel;

import java.util.Set;

public class ComponentAstFactory {

  private final DslElementModelFactory modelFactory;

  public ComponentAstFactory(Set<ExtensionModel> extensionModels) {
    modelFactory = DslElementModelFactory.getDefault(DslResolvingContext.getDefault(extensionModels));
  }

  public ComponentAst createAst(ParameterizedElementDeclaration declaration) {
    return modelFactory.create(declaration).flatMap(DslElementModel::getComponentModel).orElse(null);
  }

}
