/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import static org.hamcrest.CoreMatchers.nullValue;

import org.mule.tooling.client.api.extension.model.ErrorModel;

import java.util.Collection;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ErrorModelMatcher extends TypeSafeMatcher<ErrorModel> {

  public static Matcher<ErrorModel>[] sFrom(Collection<org.mule.runtime.api.meta.model.error.ErrorModel> runtimeErrorModel) {
    return runtimeErrorModel.stream().map(ErrorModelMatcher::from).toArray(ErrorModelMatcher[]::new);
  }

  public static Matcher<ErrorModel> from(org.mule.runtime.api.meta.model.error.ErrorModel runtimeErrorModel) {
    if (runtimeErrorModel == null) {
      return nullValue(ErrorModel.class);
    }
    return new ErrorModelMatcher(runtimeErrorModel);
  }

  private final org.mule.runtime.api.meta.model.error.ErrorModel runtimeErrorModel;

  private ErrorModelMatcher(org.mule.runtime.api.meta.model.error.ErrorModel runtimeErrorModel) {
    this.runtimeErrorModel = runtimeErrorModel;
  }

  @Override
  protected boolean matchesSafely(ErrorModel errorModel) {
    return runtimeErrorModel.getNamespace().equals(errorModel.getNamespace()) &&
        runtimeErrorModel.getType().equals(errorModel.getType()) &&
        runtimeErrorModel
            .getParent()
            .map(remp -> errorModel.getParent().map(emp -> from(remp).matches(emp)).orElse(false))
            .orElse(!errorModel.getParent().isPresent())
        &&
        (!errorModel.getHandleable().isEnabled() || runtimeErrorModel.isHandleable() == errorModel.getHandleable().get());
  }

  @Override
  protected void describeMismatchSafely(ErrorModel item, Description mismatchDescription) {
    mismatchDescription.appendText("was ErrorModel: ").appendValue(item);
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("ErrorModel: ").appendValue(runtimeErrorModel);
  }


}
