/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import static org.hamcrest.CoreMatchers.nullValue;

import org.mule.tooling.client.api.extension.model.value.FieldValueProviderModel;

import java.util.Collection;

import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class FieldValueProviderMatcher
    extends ValueProviderMatcher<FieldValueProviderModel, org.mule.runtime.api.meta.model.parameter.FieldValueProviderModel> {

  public static Matcher<FieldValueProviderModel>[] sFrom(Collection<org.mule.runtime.api.meta.model.parameter.FieldValueProviderModel> runtimeFieldModels) {
    return runtimeFieldModels.stream().map(FieldValueProviderMatcher::from).toArray(FieldValueProviderMatcher[]::new);
  }

  public static Matcher<FieldValueProviderModel> from(org.mule.runtime.api.meta.model.parameter.FieldValueProviderModel runtimeFieldModel) {
    if (runtimeFieldModel == null) {
      return nullValue(FieldValueProviderModel.class);
    }
    return new FieldValueProviderMatcher(runtimeFieldModel);
  }

  protected FieldValueProviderMatcher(org.mule.runtime.api.meta.model.parameter.FieldValueProviderModel runtimeValueProviderModel) {
    super(runtimeValueProviderModel);
  }

  @Override
  protected boolean matchesSafely(FieldValueProviderModel fieldValueProviderModel, Description description) {
    return super.matches(fieldValueProviderModel) &&
        runtimeValueProviderModel.getTargetSelector().equals(fieldValueProviderModel.getTargetSelector());
  }


  @Override
  public void describeTo(Description description) {
    description.appendText("FieldValueProviderModel: ").appendValue(runtimeValueProviderModel);
  }
}
