/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class HamcrestUtils {

  private HamcrestUtils() {}

  public static <T> boolean validateThat(String fieldName,
                                         T object,
                                         Matcher<T> matcher,
                                         Description description) {
    boolean result = matcher.matches(object);
    if (!result) {
      description.appendText("\n\n  '" + fieldName + "' expected as ")
          .appendDescriptionOf(matcher)
          .appendText("\n   but: ");
      matcher.describeMismatch(object, description);
    }
    return result;
  }


}
