/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import static java.util.Optional.ofNullable;
import static org.hamcrest.CoreMatchers.nullValue;

import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.tooling.client.api.extension.model.metadata.MetadataKeyIdModel;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class MetadataKeyIdMatcher extends TypeSafeMatcher<MetadataKeyIdModel> {

  public static Matcher<MetadataKeyIdModel> from(MetadataKeyIdModelProperty runtimeModelProperty) {
    if (runtimeModelProperty == null) {
      return nullValue(MetadataKeyIdModel.class);
    }
    return new MetadataKeyIdMatcher(runtimeModelProperty);
  }

  private final MetadataKeyIdModelProperty runtimeModelProperty;

  private MetadataKeyIdMatcher(MetadataKeyIdModelProperty runtimeModelProperty) {
    this.runtimeModelProperty = runtimeModelProperty;
  }

  @Override
  protected boolean matchesSafely(MetadataKeyIdModel item) {
    return item.getParameterName().equals(runtimeModelProperty.getParameterName()) &&
        item.getType().equals(runtimeModelProperty.getType()) &&
        (!item.getCategoryName().isEnabled()
            || ofNullable(item.getCategoryName().get()).equals(runtimeModelProperty.getCategoryName()));
  }

  @Override
  protected void describeMismatchSafely(MetadataKeyIdModel item, Description mismatchDescription) {
    mismatchDescription.appendText("was MetadataKeyIdModel: ").appendValue(item);
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("MetadataKeyIdModel: ").appendValue(runtimeModelProperty);
  }
}
