/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import static org.hamcrest.CoreMatchers.nullValue;
import static org.mule.tooling.client.internal.hamcrest.HamcrestUtils.validateThat;

import org.mule.runtime.api.util.Reference;
import org.mule.tooling.client.api.extension.model.nested.NestableElementModel;
import org.mule.tooling.client.api.extension.model.nested.NestableElementModelVisitor;
import org.mule.tooling.client.api.extension.model.nested.NestedChainModel;
import org.mule.tooling.client.api.extension.model.nested.NestedComponentModel;
import org.mule.tooling.client.api.extension.model.nested.NestedRouteModel;

import java.util.Collection;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class NestableElementMatcher extends TypeSafeDiagnosingMatcher<NestableElementModel> {

  public static Matcher<NestableElementModel> from(org.mule.runtime.api.meta.model.nested.NestableElementModel runtimeNestableModel) {
    if (runtimeNestableModel == null) {
      return nullValue(NestableElementModel.class);
    }
    return new NestableElementMatcher(runtimeNestableModel);
  }

  public static Matcher<NestableElementModel>[] sFrom(Collection<? extends org.mule.runtime.api.meta.model.nested.NestableElementModel> runtimeNestableModels) {
    return runtimeNestableModels.stream().map(NestableElementMatcher::from).toArray(NestableElementMatcher[]::new);
  }

  private final org.mule.runtime.api.meta.model.nested.NestableElementModel runtimeNestableModel;

  private NestableElementMatcher(org.mule.runtime.api.meta.model.nested.NestableElementModel runtimeNestableModel) {
    this.runtimeNestableModel = runtimeNestableModel;
  }

  @Override
  protected boolean matchesSafely(NestableElementModel nestableElementModel, Description description) {
    Reference<Boolean> result = new Reference<>(false);
    runtimeNestableModel.accept(
                                new org.mule.runtime.api.meta.model.nested.NestableElementModelVisitor() {

                                  @Override
                                  public void visit(org.mule.runtime.api.meta.model.nested.NestedComponentModel component) {
                                    result.set(validateThat(
                                                            "NestedComponentModel",
                                                            downCast(nestableElementModel, NestedComponentModel.class),
                                                            NestedComponentMatcher.from(component),
                                                            description));
                                  }

                                  @Override
                                  public void visit(org.mule.runtime.api.meta.model.nested.NestedChainModel component) {
                                    result.set(validateThat(
                                                            "NestedChainModel",
                                                            downCast(nestableElementModel, NestedChainModel.class),
                                                            NestedChainMatcher.from(component),
                                                            description));
                                  }

                                  @Override
                                  public void visit(org.mule.runtime.api.meta.model.nested.NestedRouteModel component) {
                                    result.set(validateThat(
                                                            "NestedRouteModel",
                                                            downCast(nestableElementModel, NestedRouteModel.class),
                                                            NestedRouteMatcher.from(component),
                                                            description));
                                  }
                                });
    return result.get();
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("NestableElementModel");
  }


  private <T extends NestableElementModel> T downCast(NestableElementModel model, Class<T> expectedType) {
    Reference<T> extractedModel = new Reference<>();
    model.accept(new NestableElementModelVisitor() {

      @Override
      public void visit(NestedComponentModel nestedComponentModel) {
        if (expectedType.isAssignableFrom(nestedComponentModel.getClass())) {
          extractedModel.set(expectedType.cast(nestedComponentModel));
        }
      }

      @Override
      public void visit(NestedChainModel nestedChainModel) {
        if (expectedType.isAssignableFrom(nestedChainModel.getClass())) {
          extractedModel.set(expectedType.cast(nestedChainModel));
        }
      }

      @Override
      public void visit(NestedRouteModel nestedRouteModel) {
        if (expectedType.isAssignableFrom(nestedRouteModel.getClass())) {
          extractedModel.set(expectedType.cast(nestedRouteModel));
        }
      }
    });
    return extractedModel.get();
  }

}
