/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import static org.hamcrest.CoreMatchers.nullValue;

import org.mule.tooling.client.api.extension.model.ParameterDslConfiguration;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ParameterDslConfigurationMatcher extends TypeSafeMatcher<ParameterDslConfiguration> {

  public static Matcher<ParameterDslConfiguration> from(org.mule.runtime.api.meta.model.ParameterDslConfiguration runtimeParameterDslConfiguration) {
    if (runtimeParameterDslConfiguration == null) {
      return nullValue(ParameterDslConfiguration.class);
    }
    return new ParameterDslConfigurationMatcher(runtimeParameterDslConfiguration);
  }

  private final org.mule.runtime.api.meta.model.ParameterDslConfiguration runtimeParameterDslConfiguration;

  private ParameterDslConfigurationMatcher(org.mule.runtime.api.meta.model.ParameterDslConfiguration runtimeParameterDslConfiguration) {
    this.runtimeParameterDslConfiguration = runtimeParameterDslConfiguration;
  }

  @Override
  protected boolean matchesSafely(ParameterDslConfiguration parameterDslConfiguration) {
    return runtimeParameterDslConfiguration.allowsInlineDefinition() == parameterDslConfiguration.allowsInlineDefinition() &&
        runtimeParameterDslConfiguration.allowsReferences() == parameterDslConfiguration.allowsReferences() &&
        runtimeParameterDslConfiguration.allowTopLevelDefinition() == parameterDslConfiguration.allowTopLevelDefinition();
  }

  @Override
  protected void describeMismatchSafely(ParameterDslConfiguration item, Description mismatchDescription) {
    mismatchDescription.appendText("was ParameterDslConfiguration: ").appendValue(item);
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("ParameterDslConfiguration: ").appendValue(runtimeParameterDslConfiguration);
  }

}
