/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import static java.util.Optional.empty;
import static org.hamcrest.CoreMatchers.nullValue;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.collection.IsIterableContainingInOrder.contains;
import static org.hamcrest.core.IsEqual.equalTo;
import static org.mule.tooling.client.internal.hamcrest.HamcrestUtils.validateThat;

import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;

import java.util.Collection;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class ParameterGroupMatcher extends TypeSafeDiagnosingMatcher<ParameterGroupModel> {

  public static Matcher<ParameterGroupModel>[] sFrom(Collection<org.mule.runtime.api.meta.model.parameter.ParameterGroupModel> runtimeParameterGroupModels) {
    return runtimeParameterGroupModels.stream().map(ParameterGroupMatcher::from).toArray(ParameterGroupMatcher[]::new);
  }

  public static Matcher<ParameterGroupModel> from(org.mule.runtime.api.meta.model.parameter.ParameterGroupModel runtimeParameterGroupModel) {
    if (runtimeParameterGroupModel == null) {
      return nullValue(ParameterGroupModel.class);
    }
    return new ParameterGroupMatcher(runtimeParameterGroupModel);
  }

  private final org.mule.runtime.api.meta.model.parameter.ParameterGroupModel runtimeParameterGroupModel;

  private ParameterGroupMatcher(org.mule.runtime.api.meta.model.parameter.ParameterGroupModel runtimeParameterGroupModel) {
    this.runtimeParameterGroupModel = runtimeParameterGroupModel;
  }

  @Override
  protected boolean matchesSafely(ParameterGroupModel parameterGroupModel, Description description) {
    return validateThat("name", parameterGroupModel.getName(), equalTo(runtimeParameterGroupModel.getName()), description) &&
        validateThat("isShowInDSL", parameterGroupModel.isShowInDsl(), equalTo(runtimeParameterGroupModel.isShowInDsl()),
                     description)
        &&
        validateThat("description", parameterGroupModel.getDescription(), equalTo(runtimeParameterGroupModel.getDescription()),
                     description)
        &&
        runtimeParameterGroupModel
            .getDisplayModel()
            .map(rdm -> parameterGroupModel.getDisplayModel()
                .map(dm -> validateThat("displayModel", dm, DisplayModelMatcher.from(rdm), description))
                .orElse(false))
            .orElseGet(() -> validateThat("displayModel", parameterGroupModel.getDisplayModel(), equalTo(empty()), description))
        &&
        runtimeParameterGroupModel
            .getLayoutModel()
            .map(rlm -> parameterGroupModel.getLayoutModel()
                .map(lm -> validateThat("layoutModel",
                                        lm, LayoutModelMatcher.from(rlm), description))
                .orElse(false))
            .orElseGet(() -> validateThat("layoutModel", parameterGroupModel.getLayoutModel(), equalTo(empty()), description))
        &&
        (runtimeParameterGroupModel.getExclusiveParametersModels().isEmpty()
            ? validateThat("exclusiveParameterModels", parameterGroupModel.getExclusiveParametersModels(), hasSize(0),
                           description)
            : validateThat("exclusiveParameterModels",
                           parameterGroupModel.getExclusiveParametersModels(),
                           contains(ExclusiveParameterMatcher.sFrom(runtimeParameterGroupModel.getExclusiveParametersModels())),
                           description))
        &&
        (runtimeParameterGroupModel.getParameterModels().isEmpty()
            ? validateThat("parameterModels", parameterGroupModel.getParameterModels(), hasSize(0), description)
            : validateThat("parameterModels",
                           parameterGroupModel.getParameterModels(),
                           contains(ParameterModelMatcher.sFrom(runtimeParameterGroupModel.getParameterModels())),
                           description));
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("ParameterGroupModel: ").appendValue(runtimeParameterGroupModel);
  }

}
