/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.metadata;

import static java.util.Collections.emptyList;
import static java.util.Collections.emptySet;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;
import static org.mule.runtime.api.meta.ExpressionSupport.REQUIRED;
import static org.mule.runtime.api.meta.model.ComponentVisibility.PUBLIC;
import static org.mule.runtime.api.meta.model.parameter.ParameterRole.CONTENT;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ImmutableErrorModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ExclusiveParametersModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.stereotype.ImmutableStereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;
import org.mule.runtime.extension.api.model.deprecated.ImmutableDeprecationModel;
import org.mule.runtime.extension.api.model.nested.ImmutableNestedRouteModel;
import org.mule.runtime.extension.api.model.operation.ImmutableOperationModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableExclusiveParametersModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterGroupModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.model.source.ImmutableSourceCallbackModel;
import org.mule.runtime.extension.api.model.source.ImmutableSourceModel;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;

import java.util.List;
import java.util.Optional;
import java.util.Set;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import org.junit.Before;

public abstract class AbstractMetadataTestCase {

  protected static final String OPERATION_MODEL_NAME = "create";
  protected static final String OPERATION_MODEL_DESCRIPTION = "Creates an Entity";

  protected static final String SOURCE_MODEL_NAME = "list";
  protected static final String SOURCE_MODEL_DESCRIPTION = "list entities";

  protected static final String GENERAL_PARAMETER_GROUP_MODEL_NAME = "General";
  protected static final String GENERAL_PARAMETER_GROUP_MODEL_DESCRIPTION = "General Tab";

  protected static final String TERMINATE_CALLBACK_MODEL_NAME = "terminateCallbackModelName";
  protected static final String TERMINATE_CALLBACK_MODEL_DESCRIPTION = "terminateCallbackModelName description";

  protected static final String STATIC_PARAMETER_MODEL_NAME = "staticParam";
  protected static final String STATIC_PARAMETER_MODEL_DESCRIPTION = "staticParam description";

  protected static final String DYNAMIC_PARAMETER_MODEL_NAME = "dynamicParam";
  protected static final String DYNAMIC_PARAMETER_MODEL_DESCRIPTION = "dynamicParam description";

  protected static final String STATIC_OUTPUT_MODEL_DESCRIPTION = "staticOutput description";
  protected static final String DYNAMIC_OUTPUT_MODEL_DESCRIPTION = "dynamicOutput description";

  protected static final String DEFAULT_VALUE = "defaultValue";

  protected ParameterModel staticParameterModel;
  protected ParameterModel dynamicParameterModel;

  protected OutputModel staticOutputModel;
  protected OutputModel dynamicOutputModel;

  protected DisplayModel displayModel = DisplayModel.builder()
      .displayName("displayName")
      .build();
  protected LayoutModel layoutModel = LayoutModel.builder()
      .tabName("advanced")
      .build();
  protected Set<ModelProperty> modelProperties = ImmutableSet.<ModelProperty>builder()
      .add(new ClassLoaderModelProperty(this.getClass().getClassLoader()))
      .build();

  protected DeprecationModel deprecationModel = new ImmutableDeprecationModel("message", "1.0", "2.0");

  protected DefaultStringType stringType = new BaseTypeBuilder(MetadataFormat.JAVA).stringType().build();
  protected ObjectType objectType = new BaseTypeBuilder(MetadataFormat.JAVA).objectType().build();

  protected StereotypeModel stereotype = new ImmutableStereotypeModel("name", "namespace", null);
  protected ValueProviderModel valueProviderModel =
      new ValueProviderModel(from(ImmutableList.of("param")), true, true, true, 0, "providerName", "providerId");
  protected ParameterDslConfiguration parameterDslConfiguration = ParameterDslConfiguration.builder()
      .allowsInlineDefinition(true)
      .allowsReferences(true)
      .allowTopLevelDefinition(true)
      .build();

  protected Set<ErrorModel> errors;

  protected List<ExclusiveParametersModel> exclusiveParameterModels =
      ImmutableList.of(new ImmutableExclusiveParametersModel(ImmutableSet.of("timeout"), true));
  protected List<NestableElementModel> nestedComponents;

  @Before
  public void before() {
    staticParameterModel = new ImmutableParameterModel(STATIC_PARAMETER_MODEL_NAME,
                                                       STATIC_PARAMETER_MODEL_DESCRIPTION,
                                                       stringType,
                                                       false,
                                                       true,
                                                       true,
                                                       REQUIRED,
                                                       DEFAULT_VALUE,
                                                       CONTENT,
                                                       parameterDslConfiguration,
                                                       displayModel,
                                                       layoutModel,
                                                       valueProviderModel,
                                                       ImmutableList.of(stereotype),
                                                       modelProperties);

    dynamicParameterModel = new ImmutableParameterModel(DYNAMIC_PARAMETER_MODEL_NAME,
                                                        DYNAMIC_PARAMETER_MODEL_DESCRIPTION,
                                                        stringType,
                                                        true,
                                                        true,
                                                        true,
                                                        REQUIRED,
                                                        DEFAULT_VALUE,
                                                        CONTENT,
                                                        parameterDslConfiguration,
                                                        displayModel,
                                                        layoutModel,
                                                        valueProviderModel,
                                                        ImmutableList.of(stereotype),
                                                        modelProperties);

    staticOutputModel = new ImmutableOutputModel(STATIC_OUTPUT_MODEL_DESCRIPTION,
                                                 stringType,
                                                 false,
                                                 modelProperties);

    dynamicOutputModel = new ImmutableOutputModel(DYNAMIC_OUTPUT_MODEL_DESCRIPTION,
                                                  stringType,
                                                  true,
                                                  modelProperties);

    errors = ImmutableSet.of(new ImmutableErrorModel("type", "namespace", true, null));

    nestedComponents = ImmutableList
        .of(new ImmutableNestedRouteModel("name", "description", emptyList(), displayModel, 0, 1, emptyList(), PUBLIC,
                                          modelProperties));
  }

  protected OperationModel getOperationModel(List<ParameterModel> inputParameterModels, OutputModel outputModel,
                                             OutputModel outputAttributesModel) {
    ParameterGroupModel parameterGroupModel = new ImmutableParameterGroupModel(GENERAL_PARAMETER_GROUP_MODEL_NAME,
                                                                               GENERAL_PARAMETER_GROUP_MODEL_DESCRIPTION,
                                                                               inputParameterModels,
                                                                               exclusiveParameterModels,
                                                                               true,
                                                                               displayModel,
                                                                               layoutModel,
                                                                               modelProperties);
    List<ParameterGroupModel> parameterGroupModels = ImmutableList.of(parameterGroupModel);

    return new ImmutableOperationModel(OPERATION_MODEL_NAME,
                                       OPERATION_MODEL_DESCRIPTION,
                                       parameterGroupModels,
                                       nestedComponents,
                                       outputModel,
                                       outputAttributesModel,
                                       true,
                                       ExecutionType.BLOCKING,
                                       true,
                                       true,
                                       true,
                                       displayModel,
                                       errors,
                                       stereotype,
                                       PUBLIC,
                                       modelProperties,
                                       emptySet(),
                                       deprecationModel);
  }


  protected SourceModel getSourceModel(List<ParameterModel> inputParameterModels, OutputModel outputModel,
                                       OutputModel outputAttributesModel) {
    ParameterGroupModel parameterGroupModel = new ImmutableParameterGroupModel(GENERAL_PARAMETER_GROUP_MODEL_NAME,
                                                                               GENERAL_PARAMETER_GROUP_MODEL_DESCRIPTION,
                                                                               inputParameterModels,
                                                                               exclusiveParameterModels,
                                                                               true,
                                                                               displayModel,
                                                                               layoutModel,
                                                                               modelProperties);
    List<ParameterGroupModel> parameterGroupModels = ImmutableList.of(parameterGroupModel);

    // TODO: MULE-17263
    Optional<SourceCallbackModel> successCallbackModel = of(new ImmutableSourceCallbackModel(TERMINATE_CALLBACK_MODEL_NAME,
                                                                                             TERMINATE_CALLBACK_MODEL_DESCRIPTION,
                                                                                             ImmutableList
                                                                                                 .of(new ImmutableParameterGroupModel(GENERAL_PARAMETER_GROUP_MODEL_NAME,
                                                                                                                                      GENERAL_PARAMETER_GROUP_MODEL_DESCRIPTION,
                                                                                                                                      ImmutableList
                                                                                                                                          .of(staticParameterModel),
                                                                                                                                      exclusiveParameterModels,
                                                                                                                                      true,
                                                                                                                                      displayModel,
                                                                                                                                      layoutModel,
                                                                                                                                      modelProperties)),
                                                                                             displayModel,
                                                                                             modelProperties));
    // TODO: MULE-17263
    Optional<SourceCallbackModel> errorCallbackModel = of(new ImmutableSourceCallbackModel(TERMINATE_CALLBACK_MODEL_NAME,
                                                                                           TERMINATE_CALLBACK_MODEL_DESCRIPTION,
                                                                                           ImmutableList
                                                                                               .of(new ImmutableParameterGroupModel(GENERAL_PARAMETER_GROUP_MODEL_NAME,
                                                                                                                                    GENERAL_PARAMETER_GROUP_MODEL_DESCRIPTION,
                                                                                                                                    ImmutableList
                                                                                                                                        .of(staticParameterModel),
                                                                                                                                    exclusiveParameterModels,
                                                                                                                                    true,
                                                                                                                                    displayModel,
                                                                                                                                    layoutModel,
                                                                                                                                    modelProperties)),
                                                                                           displayModel,
                                                                                           modelProperties));
    Optional<SourceCallbackModel> terminateCallbackModel = of(new ImmutableSourceCallbackModel(TERMINATE_CALLBACK_MODEL_NAME,
                                                                                               TERMINATE_CALLBACK_MODEL_DESCRIPTION,
                                                                                               ImmutableList
                                                                                                   .of(new ImmutableParameterGroupModel(GENERAL_PARAMETER_GROUP_MODEL_NAME,
                                                                                                                                        GENERAL_PARAMETER_GROUP_MODEL_DESCRIPTION,
                                                                                                                                        ImmutableList
                                                                                                                                            .of(staticParameterModel),
                                                                                                                                        exclusiveParameterModels,
                                                                                                                                        true,
                                                                                                                                        displayModel,
                                                                                                                                        layoutModel,
                                                                                                                                        modelProperties)),
                                                                                               displayModel,
                                                                                               modelProperties));

    return new ImmutableSourceModel(SOURCE_MODEL_NAME,
                                    SOURCE_MODEL_DESCRIPTION,
                                    true,
                                    true,
                                    parameterGroupModels,
                                    nestedComponents,
                                    outputModel,
                                    outputAttributesModel,
                                    // TODO: MULE-17263
                                    successCallbackModel,
                                    // TODO: MULE-17263
                                    errorCallbackModel,
                                    terminateCallbackModel,
                                    true,
                                    true,
                                    true,
                                    displayModel,
                                    stereotype,
                                    errors,
                                    PUBLIC,
                                    modelProperties,
                                    emptySet(),
                                    deprecationModel);
  }

  private List<org.mule.runtime.api.meta.model.parameter.ActingParameterModel> from(List<String> actingParameters) {
    return actingParameters.stream()
        .map(name -> new org.mule.runtime.extension.api.model.parameter.ImmutableActingParameterModel(name, true))
        .collect(toList());
  }
}
