/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.util.Optional;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.api.dsl.model.metadata.ModelBasedMetadataCacheIdGeneratorFactory;
import org.mule.runtime.metadata.api.cache.MetadataCacheIdGenerator;
import org.mule.runtime.metadata.api.locator.ComponentLocator;
import org.mule.tooling.client.api.component.location.Location;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.feature.Action;
import org.mule.tooling.client.api.feature.Feature;
import org.mule.tooling.client.api.metadata.MetadataKeysRequest;
import org.mule.tooling.client.api.metadata.MetadataService;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.MetadataPartsFactory;
import org.mule.tooling.client.internal.MetadataProvider;
import org.mule.tooling.client.internal.action.DispacheableAction;
import org.mule.tooling.client.internal.metadata.MetadataCache;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.utils.ComponentModelLocatorHelper;

public class ToolingMetadataServiceAdapter
implements MetadataService,
Command {
    private LazyValue<ArtifactAst> applicationModel;
    private LazyValue<ComponentLocator<ComponentAst>> componentLocator;
    private LazyValue<MetadataCacheIdGenerator<ComponentAst>> metadataCacheIdGenerator;
    private MetadataProvider metadataProvider;
    private LazyValue<MetadataCache> metadataCache;
    private Serializer serializer;
    private final ComponentModelLocatorHelper componentModelLocatorHelper;

    public ToolingMetadataServiceAdapter(LazyValue<ArtifactAst> applicationModel, MetadataProvider metadataProvider, LazyValue<MetadataCache> metadataCache, Serializer serializer, LazyValue<DslResolvingContext> dslResolvingContext, LazyValue<ComponentLocator<ComponentAst>> componentLocator) {
        com.google.common.base.Preconditions.checkNotNull(applicationModel, (Object)"applicationModel cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)metadataProvider, (Object)"metadataProvider cannot be null");
        com.google.common.base.Preconditions.checkNotNull(metadataCache, (Object)"metadataCache cannot be null");
        com.google.common.base.Preconditions.checkNotNull(dslResolvingContext, (Object)"dslResolvingContext cannot be null");
        this.applicationModel = applicationModel;
        this.metadataProvider = metadataProvider;
        this.metadataCache = metadataCache;
        this.componentLocator = componentLocator;
        this.serializer = serializer;
        this.componentModelLocatorHelper = new ComponentModelLocatorHelper();
        this.metadataCacheIdGenerator = new LazyValue(() -> new ModelBasedMetadataCacheIdGeneratorFactory().create((DslResolvingContext)dslResolvingContext.get(), (ComponentLocator)componentLocator.get()));
    }

    public org.mule.tooling.client.api.metadata.MetadataResult<org.mule.tooling.client.api.metadata.MetadataKeysContainer> getMetadataKeys(MetadataKeysRequest metadataKeysRequest) throws ServiceUnavailableException {
        Optional<ComponentAst> componentModel = this.componentModelLocatorHelper.findComponentModel((ArtifactAst)this.applicationModel.get(), metadataKeysRequest.getLocation());
        MetadataResult metadataKeys = !componentModel.isPresent() ? MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(String.format("No object found at location %s", metadataKeysRequest.getLocation().toString())).withFailureCode(FailureCode.COMPONENT_NOT_FOUND).onKeys()}) : ((MetadataCache)this.metadataCache.get()).getMetadataKeys(componentModel.get(), () -> this.metadataProvider.getMetadataKeys(metadataKeysRequest));
        return MetadataPartsFactory.toMetadataResultDTO(metadataKeys, () -> MetadataPartsFactory.toMetadataKeysContainerDTO((MetadataKeysContainer)metadataKeys.get()));
    }

    private void invalidateRuntimeCacheFor(ComponentAst componentAst) {
        ((MetadataCacheIdGenerator)this.metadataCacheIdGenerator.get()).getIdForGlobalMetadata((Object)componentAst).ifPresent(metadataCacheId -> this.metadataProvider.disposeMetadataCache(metadataCacheId.getValue()));
    }

    public Feature<Action<Location>> disposeMetadataCache() {
        return Feature.enabled(new DispacheableAction<Location>(location -> {
            org.mule.runtime.api.component.location.Location componentLocation = org.mule.runtime.api.component.location.Location.builderFromStringRepresentation((String)location.toString()).build();
            ((ComponentLocator)this.componentLocator.get()).get(componentLocation).ifPresent(componentConfiguration -> {
                this.invalidateRuntimeCacheFor((ComponentAst)componentConfiguration);
                ((MetadataCache)this.metadataCache.get()).dispose((ComponentAst)componentConfiguration);
            });
        }, Location.class, this.serializer));
    }

    public Feature<Action<Location>> invalidateMetadataCacheKeys() {
        return Feature.enabled(new DispacheableAction<Location>(location -> {
            org.mule.runtime.api.component.location.Location componentLocation = org.mule.runtime.api.component.location.Location.builderFromStringRepresentation((String)location.toString()).build();
            ((ComponentLocator)this.componentLocator.get()).get(componentLocation).ifPresent(componentConfiguration -> {
                this.invalidateRuntimeCacheFor((ComponentAst)componentConfiguration);
                ((MetadataCache)this.metadataCache.get()).invalidateMetadataKeysFor((ComponentAst)componentConfiguration);
            });
        }, Location.class, this.serializer));
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "getMetadataKeys": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(MetadataKeysRequest.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return this.serializer.serialize(this.getMetadataKeys((MetadataKeysRequest)this.serializer.deserialize(arguments[0])));
            }
            case "disposeMetadataCache": {
                return this.disposeMetadataCache();
            }
            case "invalidateMetadataCacheKeys": {
                return this.invalidateMetadataCacheKeys();
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

