/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal;

import org.mule.datasense.api.metadataprovider.DataSenseMetadataCacheProvider;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.tooling.client.internal.datasense.DataSenseArtifact;
import org.mule.tooling.client.internal.metadata.MetadataCache;

import java.util.Map;
import java.util.concurrent.Callable;


public class DataSenseMetadataCacheAdapter implements DataSenseMetadataCacheProvider {

  private DataSenseArtifact dataSenseArtifact;

  public DataSenseMetadataCacheAdapter(DataSenseArtifact dataSenseArtifact) {
    this.dataSenseArtifact = dataSenseArtifact;
  }

  @Override
  public MetadataResult<OperationModel> getOperationMetadata(ComponentAst componentAst,
                                                             Callable<MetadataResult<OperationModel>> callable) {
    Pair<MetadataCache, Map<String, String>> input = getDataSenseCache(componentAst.getLocation());
    return input.getFirst().getOperationMetadata(componentAst, callable);
  }

  @Override
  public MetadataResult<SourceModel> getSourceMetadata(ComponentAst componentAst,
                                                       Callable<MetadataResult<SourceModel>> callable) {
    Pair<MetadataCache, Map<String, String>> input = getDataSenseCache(componentAst.getLocation());
    return input.getFirst().getSourceMetadata(componentAst, callable);
  }

  @Override
  public MetadataResult<MetadataKeysContainer> getMetadataKeys(ComponentAst componentAst,
                                                               Callable<MetadataResult<MetadataKeysContainer>> callable) {
    Pair<MetadataCache, Map<String, String>> input = getDataSenseCache(componentAst.getLocation());
    return input.getFirst().getMetadataKeys(componentAst, callable);
  }

  private Pair<MetadataCache, Map<String, String>> getDataSenseCache(ComponentLocation componentLocation) {
    Pair<MetadataCache, Map<String, String>> input;
    if (dataSenseArtifact.getParent().isPresent() && dataSenseArtifact.getParent().get().hasComponentModel(componentLocation)) {
      DataSenseArtifact parent = this.dataSenseArtifact.getParent().get();
      input = new Pair<>(parent.getMetadataCache(), parent.getProperties());
    } else {
      input = new Pair<>(dataSenseArtifact.getMetadataCache(), dataSenseArtifact.getProperties());
    }
    return input;
  }

}
