/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal;

import static com.google.common.base.Preconditions.checkNotNull;
import static org.mule.tooling.client.internal.utils.SampleDataUtils.toComponentSampleDataResult;

import org.mule.tooling.api.sampledata.SampleDataMessageModelFailure;
import org.mule.tooling.api.sampledata.SampleDataMessageModelResult;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.api.sampledata.ComponentSampleDataResult;
import org.mule.tooling.client.api.sampledata.SampleDataService;
import org.mule.tooling.client.api.sampledata.request.SampleDataRequest;
import org.mule.tooling.client.internal.application.RemoteApplicationInvoker;
import org.mule.tooling.client.internal.serialization.Serializer;

public class SampleDataProviderServiceAdapter implements SampleDataService, Command {

  private final RemoteApplicationInvoker remoteApplicationInvoker;
  private final Serializer serializer;

  public SampleDataProviderServiceAdapter(RemoteApplicationInvoker remoteApplicationInvoker,
                                          Serializer serializer) {
    checkNotNull(remoteApplicationInvoker, "remote application invoker cannot be null");
    checkNotNull(serializer, "serializer cannot be null");
    this.remoteApplicationInvoker = remoteApplicationInvoker;
    this.serializer = serializer;
  }

  @Override
  public ComponentSampleDataResult getSampleData(SampleDataRequest sampleDataRequest) {
    try {
      return toComponentSampleDataResult(remoteApplicationInvoker.evaluateWithRemoteApplication(
                                                                                                (appId,
                                                                                                 toolingService) -> toolingService
                                                                                                     .getSampleDataApplication(appId,
                                                                                                                               sampleDataRequest
                                                                                                                                   .getLocation(),
                                                                                                                               sampleDataRequest
                                                                                                                                   .getRequestTimeout())));
    } catch (ToolingException e) {
      throw e;
    } catch (Exception e) {
      return toComponentSampleDataResult(new SampleDataMessageModelResult(new SampleDataMessageModelFailure(e)));
    }
  }

  @Override
  public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
    if ("getSampleData".equals(methodName)) {
      validateInput(arguments, classes, SampleDataRequest.class);
      final SampleDataRequest sampleDataRequest = serializer.deserialize(arguments[0]);
      return serializer.serialize(this.getSampleData(sampleDataRequest));
    }
    throw Command.methodNotFound(this.getClass(), methodName);
  }
}
