/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.metadata;

import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.internal.ExtensionModelTargetVersionMediator;

/**
 * Mediator that filters the response from Mule Runtime for {@link ComponentModel} according to the target Mule Runtime version
 * for which Tooling Runtime Client has been created.
 *
 * @since 4.2.0
 */
public class MetadataMediatorRuntimeToolingServiceDecorator extends AbstractRuntimeToolingServiceDecorator {

  private MuleVersion targetMuleVersion;

  public MetadataMediatorRuntimeToolingServiceDecorator(MuleVersion targetMuleVersion, RuntimeToolingService delegate) {
    super(delegate);
    this.targetMuleVersion = targetMuleVersion;
  }

  @Override
  public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(String applicationId,
                                                                                          String componentLocation,
                                                                                          long readTimeout)
      throws ServiceUnavailableException {
    return getFilteredComponentMetadataDescriptorMetadataResult(super.getOperationMetadata(applicationId, componentLocation,
                                                                                           readTimeout));
  }

  @Override
  public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(String applicationId,
                                                                                    String componentLocation, long readTimeout)
      throws ServiceUnavailableException {
    return getFilteredComponentMetadataDescriptorMetadataResult(super.getSourceMetadata(applicationId, componentLocation,
                                                                                        readTimeout));
  }

  private <T extends ComponentModel> MetadataResult<ComponentMetadataDescriptor<T>> getFilteredComponentMetadataDescriptorMetadataResult(MetadataResult<ComponentMetadataDescriptor<T>> metadataResult) {
    if (metadataResult.isSuccess()) {
      T filteredComponentModel =
          new ExtensionModelTargetVersionMediator.ComponentModelMediator<>(targetMuleVersion, metadataResult.get().getModel())
              .getFilteredComponentModel();
      return MetadataResult.success(ComponentMetadataDescriptor.builder(filteredComponentModel)
          .withAttributes(metadataResult.get().getMetadataAttributes()).build());
    }
    return metadataResult;
  }

}
