/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.metadata;

import static java.util.Optional.empty;
import org.mule.sdk.api.values.ValueProvider;
import org.mule.tooling.client.internal.values.ValueProviderCache;

import java.util.Optional;

/**
 * Generates keys to use in a {@link MetadataCache} and {@link ValueProviderCache}
 *
 * @since 4.4.0
 */
public interface ToolingCacheIdGenerator<T> {

  Optional<String> getIdForComponentOutputMetadata(T component);

  Optional<String> getIdForComponentAttributesMetadata(T component);

  Optional<String> getIdForComponentInputMetadata(T component, String parameterName);

  Optional<String> getIdForComponentMetadata(T component);

  Optional<String> getIdForMetadataKeys(T component);

  Optional<String> getIdForGlobalMetadata(T component);

  Optional<String> getIdForResolvedValues(T component, String parameterName);

  Optional<String> getIdForResolvedValues(T component, String parameterName, String targetSelector);

  /**
   * Get the {@link Optional<String>} with the id computed for the component that is a dependency (part) that affects values
   * resolution.
   *
   * e.g: Get the id of a config that is referenced by an operation for which a parameter has a {@link ValueProvider}
   * 
   * @param component the component that is referenced by the owner of the parameter.
   * @return an {@link Optional<String>} with the computed Id
   */
  default Optional<String> getIdForResolvedValuesDependency(T component) {
    return empty();
  }
}
