/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session;

import static org.mule.runtime.app.declaration.api.component.location.Location.builderFromStringRepresentation;
import static org.mule.runtime.app.declaration.api.fluent.ElementDeclarer.newArtifact;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.TopLevelParameterDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ArtifactDeclarer;
import org.mule.runtime.metadata.api.locator.ComponentLocator;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

/**
 * Implementation for {@link ComponentLocator<ElementDeclaration>} that is able to "find" {@link ElementDeclaration}s used to
 * configure the {@link org.mule.tooling.client.api.declaration.session.DeclarationSession} like:
 * {@link ConfigurationElementDeclaration}s, {@link ConnectionElementDeclaration}s, or {@link TopLevelParameterDeclaration}.
 *
 * @since 4.4.0
 */
public class DeclarationSessionComponentLocator implements ComponentLocator<ElementDeclaration> {

  private final ArtifactDeclaration dummyArtifact;

  public DeclarationSessionComponentLocator(List<? extends GlobalElementDeclaration>... locatableGlobalElements) {
    ArtifactDeclarer artifactDeclarer = newArtifact();
    Arrays.stream(locatableGlobalElements).flatMap(Collection::stream).forEach(artifactDeclarer::withGlobalElement);
    this.dummyArtifact = artifactDeclarer.getDeclaration();
  }

  @Override
  public Optional<ElementDeclaration> get(Location location) {
    return dummyArtifact.findElement(builderFromStringRepresentation(location.toString()).build());
  }
}
