/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session;

import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.session.factory.RemoteDeclarationSessionDeployment;
import org.mule.tooling.client.internal.session.factory.RemoteDeclarationSessionProvider;

import java.util.function.Function;

import javax.validation.ValidationException;

public class RemoteSessionExecutor {

  private final RemoteDeclarationSessionProvider remoteDeclarationSessionProvider;

  public RemoteSessionExecutor(RemoteDeclarationSessionProvider remoteDeclarationSessionProvider) {
    this.remoteDeclarationSessionProvider = remoteDeclarationSessionProvider;
  }

  public <T> T withRemoteDeclarationSession(Function<String, T> onSuccess, Function<Exception, T> onError) {
    RemoteDeclarationSessionDeployment declarationSessionDeployment =
        this.remoteDeclarationSessionProvider.getRemoteDeclarationSession();
    if (!declarationSessionDeployment.isSuccess()) {
      Exception exception = declarationSessionDeployment.getException();
      if (exception instanceof ValidationException) {
        return onError.apply(exception);
      }

      if (exception instanceof ToolingException) {
        throw (ToolingException) exception;
      }
      throw new ToolingException(exception);
    }
    return onSuccess.apply(declarationSessionDeployment.getId());
  }

}
