/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session.factory;

public class RemoteDeclarationSessionDeployment {

  private String id;
  private Exception exception;

  private RemoteDeclarationSessionDeployment(String id, Exception exception) {
    this.id = id;
    this.exception = exception;
  }

  public static RemoteDeclarationSessionDeployment success(String id) {
    return new RemoteDeclarationSessionDeployment(id, null);
  }

  public static RemoteDeclarationSessionDeployment failure(Exception exception) {
    return new RemoteDeclarationSessionDeployment(null, exception);
  }

  public String getId() {
    return this.id;
  }

  public Exception getException() {
    return this.exception;
  }

  public boolean isSuccess() {
    return this.exception == null;
  }

}
