/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session.mediator.resolver;

import static java.lang.String.format;
import static org.mule.tooling.client.api.value.resolver.ValueResolverResult.failure;

import org.mule.tooling.client.api.value.resolver.ValueResolverFailure;
import org.mule.tooling.client.api.value.resolver.ValueResolverResult;

import org.jetbrains.annotations.NotNull;

public abstract class SkeletalValueResolver<T> {

  protected static final String INVALID_ACTING_PARAMETER_VALUES = "INVALID_ACTING_PARAMETER_VALUES";
  protected static final String MISSING_REQUIRED_PARAMETERS = "MISSING_REQUIRED_PARAMETERS";

  protected final SessionFunction<T> sessionFunction;
  protected final boolean ignoreCache;

  protected SkeletalValueResolver(SessionFunction<T> sessionFunction,
                                  boolean ignoreCache) {
    this.ignoreCache = ignoreCache;
    this.sessionFunction = sessionFunction;
  }

  @NotNull
  protected ValueResolverResult invalidActingParameterFailure(String invalidParameter, String reason) {
    return failure(new ValueResolverFailure(format("Acting parameters have values that are not valid: ['%s']", invalidParameter),
                                            reason,
                                            INVALID_ACTING_PARAMETER_VALUES));
  }

  @NotNull
  protected ValueResolverResult unknownActingParametersFailure(String invalidParameter, String invalidValue) {
    return failure(new ValueResolverFailure(format("Acting parameters have unknown values: ['%s':%s]",
                                                   invalidParameter, invalidValue),
                                            "The values assigned to acting parameters represent unknown options",
                                            INVALID_ACTING_PARAMETER_VALUES));
  }

  @NotNull
  protected ValueResolverResult missingActingParametersFailure(String missingParameter) {
    return failure(new ValueResolverFailure(format("There are missing acting parameters: ['%s']", missingParameter),
                                            "Acting parameters required for the resolution are missing",
                                            MISSING_REQUIRED_PARAMETERS));
  }


}
