/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.utils;

import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.property.TypeResolversInformationModelProperty;

public class MetadataTypesUtils {

  public static boolean requiresConnection(ParameterizedModel parameterizedModel,
                                           TypeResolversInformationModelProperty modelProperty) {
    Reference<Boolean> requiresConnection = new Reference<>(false);
    modelProperty.getOutputResolver()
        .ifPresent(or -> requiresConnection.set(requiresConnection.get() || or.isRequiresConnection()));
    modelProperty.getAttributesResolver()
        .ifPresent(ar -> requiresConnection.set(requiresConnection.get() || ar.isRequiresConnection()));
    parameterizedModel.getAllParameterModels().forEach(
                                                       pm -> modelProperty.getParameterResolver(pm.getName())
                                                           .ifPresent(ir -> requiresConnection
                                                               .set(requiresConnection.get() || ir.isRequiresConnection())));
    return requiresConnection.get();
  }

  public static boolean requiresConfiguration(ParameterizedModel parameterizedModel,
                                              TypeResolversInformationModelProperty modelProperty) {
    Reference<Boolean> requiresConfiguration = new Reference<>(false);
    modelProperty.getOutputResolver()
        .ifPresent(or -> requiresConfiguration.set(requiresConfiguration.get() || or.isRequiresConfiguration()));
    modelProperty.getAttributesResolver()
        .ifPresent(ar -> requiresConfiguration.set(requiresConfiguration.get() || ar.isRequiresConfiguration()));
    parameterizedModel.getAllParameterModels().forEach(
                                                       pm -> modelProperty.getParameterResolver(pm.getName())
                                                           .ifPresent(ir -> requiresConfiguration.set(requiresConfiguration.get()
                                                               || ir.isRequiresConfiguration())));
    return requiresConfiguration.get();
  }

}
