/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.utils;

import static java.util.stream.Collectors.toCollection;
import static java.util.stream.Collectors.toSet;
import static org.mule.tooling.client.api.value.resolver.ValueResolverResult.failure;
import static org.mule.tooling.client.api.value.resolver.ValueResolverResult.success;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueResult;
import org.mule.tooling.client.api.value.resolver.ResolvedValue;
import org.mule.tooling.client.api.value.resolver.ValueResolverFailure;
import org.mule.tooling.client.api.value.resolver.ValueResolverResult;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ValueResolverUtils {

  public static ValueResolverResult toValueResolverResult(ValueResult valueResult) {
    if (valueResult.isSuccess()) {
      return success(toResolvedValues(valueResult.getValues()));
    }
    return failure(toValueResolvedFailure(valueResult.getFailure()));
  }

  public static Set<ResolvedValue> toResolvedValues(Set<Value> values) {
    return values.stream().map(ValueResolverUtils::toResolvedValue).collect(toCollection(LinkedHashSet::new));
  }

  public static ValueResolverResult toValueResolverResult(Set<MetadataKey> metadataKeys) {
    return success(metadataKeys.stream().map(ValueResolverUtils::toResolvedValue).collect(toCollection(LinkedHashSet::new)));
  }

  private static ResolvedValue toResolvedValue(MetadataKey metadataKey) {
    return new ResolvedValue(metadataKey.getId(), metadataKey.getDisplayName());
  }

  private static ResolvedValue toResolvedValue(Value value) {
    return new ResolvedValue(value.getId(), value.getDisplayName());
  }

  private static ValueResolverFailure toValueResolvedFailure(Optional<ResolvingFailure> resolvingFailureOptional) {
    return resolvingFailureOptional.map(r -> new ValueResolverFailure(r.getMessage(), r.getReason(), r.getFailureCode()))
        .orElse(null);
  }

}
