/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import static org.hamcrest.CoreMatchers.nullValue;

import org.mule.tooling.client.api.extension.model.parameter.ExclusiveParametersModel;

import java.util.Collection;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ExclusiveParameterMatcher extends TypeSafeMatcher<ExclusiveParametersModel> {

  public static Matcher<ExclusiveParametersModel>[] sFrom(Collection<org.mule.runtime.api.meta.model.parameter.ExclusiveParametersModel> runtimeExclusiveParameterModels) {
    return runtimeExclusiveParameterModels.stream().map(ExclusiveParameterMatcher::from)
        .toArray(ExclusiveParameterMatcher[]::new);
  }

  public static Matcher<ExclusiveParametersModel> from(org.mule.runtime.api.meta.model.parameter.ExclusiveParametersModel runtimeExclusiveParameterModel) {
    if (runtimeExclusiveParameterModel == null) {
      return nullValue(ExclusiveParametersModel.class);
    }
    return new ExclusiveParameterMatcher(runtimeExclusiveParameterModel);
  }

  private final org.mule.runtime.api.meta.model.parameter.ExclusiveParametersModel runtimeExclusiveParameterModel;

  private ExclusiveParameterMatcher(org.mule.runtime.api.meta.model.parameter.ExclusiveParametersModel runtimeExclusiveParameterModel) {
    this.runtimeExclusiveParameterModel = runtimeExclusiveParameterModel;
  }

  @Override
  protected boolean matchesSafely(ExclusiveParametersModel exclusiveParametersModel) {
    return runtimeExclusiveParameterModel.isOneRequired() == exclusiveParametersModel.isOneRequired() &&
        runtimeExclusiveParameterModel.getExclusiveParameterNames().equals(exclusiveParametersModel.getExclusiveParameterNames());
  }

  @Override
  protected void describeMismatchSafely(ExclusiveParametersModel item, Description mismatchDescription) {
    mismatchDescription.appendText("was ExclusiveParametersModel: ").appendValue(item);
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("ExclusiveParametersModel: ").appendValue(runtimeExclusiveParameterModel);
  }
}
