/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.nullValue;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.collection.IsIterableContainingInOrder.contains;
import static org.mule.tooling.client.internal.hamcrest.HamcrestUtils.validateThat;

import org.mule.tooling.client.api.extension.model.data.sample.SampleDataProviderModel;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class SampleDataMatcher extends TypeSafeDiagnosingMatcher<SampleDataProviderModel> {

  public static Matcher<SampleDataProviderModel> from(org.mule.runtime.api.meta.model.data.sample.SampleDataProviderModel runtimeModel) {
    if (runtimeModel == null) {
      return nullValue(SampleDataProviderModel.class);
    }
    return new SampleDataMatcher(runtimeModel);
  }

  private final org.mule.runtime.api.meta.model.data.sample.SampleDataProviderModel runtimeModel;

  private SampleDataMatcher(org.mule.runtime.api.meta.model.data.sample.SampleDataProviderModel runtimeModel) {
    this.runtimeModel = runtimeModel;
  }

  @Override
  protected boolean matchesSafely(SampleDataProviderModel item, Description description) {
    return validateThat("requiresConfiguration", item.requiresConfiguration(),
                        equalTo(runtimeModel.requiresConfiguration()), description)
        &&
        validateThat("requiresConnection", item.requiresConnection(),
                     equalTo(runtimeModel.requiresConnection()), description)
        &&
        validateThat("providerId", item.getProviderId(), equalTo(runtimeModel.getProviderId()), description)
        &&
        (runtimeModel.getParameters().isEmpty()
            ? validateThat("actingParameterModels", item.getParameters(), hasSize(0), description)
            : validateThat("ActingParameterModels", item.getParameters(),
                           contains(ActingParameterMatcher.sFrom(runtimeModel.getParameters())), description));
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("SampleDataProviderModel: ").appendValue(runtimeModel);
  }
}
