/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.extension.ExtensionModelService;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.ExtensionModelFactory;
import org.mule.tooling.client.internal.MuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.util.Preconditions;

public class ToolingExtensionModelAdapter
implements ExtensionModelService,
Command {
    private MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider;
    private Serializer serializer;
    private Optional<MuleVersion> targetRuntimeVersion;

    public ToolingExtensionModelAdapter(MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider, Serializer serializer, Optional<MuleVersion> targetRuntimeVersion) {
        this.muleRuntimeExtensionModelProvider = muleRuntimeExtensionModelProvider;
        this.serializer = serializer;
        this.targetRuntimeVersion = targetRuntimeVersion;
    }

    public Optional<org.mule.tooling.client.api.extension.model.ExtensionModel> loadExtensionModel(ArtifactDescriptor pluginDescriptor) {
        Objects.requireNonNull(pluginDescriptor, "pluginDescriptor cannot be null");
        return this.muleRuntimeExtensionModelProvider.getExtensionModel(pluginDescriptor).map(runtimeExtensionModel -> this.toDTO((ExtensionModel)runtimeExtensionModel, this.muleRuntimeExtensionModelProvider.getMinMuleVersion(pluginDescriptor).get()));
    }

    public Optional<org.mule.tooling.client.api.extension.model.ExtensionModel> loadExtensionModel(File pluginFile) {
        Objects.requireNonNull(pluginFile, "pluginFile cannot be null");
        return this.muleRuntimeExtensionModelProvider.getExtensionModel(pluginFile).map(loadedExtensionInformation -> this.toDTO(loadedExtensionInformation.getExtensionModel(), loadedExtensionInformation.getMinMuleVersion()));
    }

    public Optional<String> loadExtensionSchema(ArtifactDescriptor pluginDescriptor) {
        Objects.requireNonNull(pluginDescriptor, "pluginDescriptor cannot be null");
        return this.muleRuntimeExtensionModelProvider.getExtensionSchema(pluginDescriptor);
    }

    public Optional<String> loadExtensionSchema(File pluginFile) {
        Objects.requireNonNull(pluginFile, "pluginDescriptor cannot be null");
        return this.muleRuntimeExtensionModelProvider.getExtensionSchema(pluginFile);
    }

    public List<org.mule.tooling.client.api.extension.model.ExtensionModel> loadMuleExtensionModels() {
        return this.muleRuntimeExtensionModelProvider.getRuntimeExtensionModels().stream().map(runtimeExtensionModel -> this.toDTO((ExtensionModel)runtimeExtensionModel, runtimeExtensionModel.getVersion())).collect(Collectors.toList());
    }

    private org.mule.tooling.client.api.extension.model.ExtensionModel toDTO(ExtensionModel runtimeExtensionModel, String minMuleVersion) {
        return new ExtensionModelFactory(this.targetRuntimeVersion).createExtensionModel(runtimeExtensionModel, minMuleVersion);
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "loadExtensionModel": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                String argClazz = classes[0];
                Preconditions.checkState((classes.length == 1 && (argClazz.equals(ArtifactDescriptor.class.getName()) || argClazz.equals(File.class.getName())) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                if (argClazz.equals(ArtifactDescriptor.class.getName())) {
                    return this.serializer.serialize(this.loadExtensionModel((ArtifactDescriptor)this.serializer.deserialize(arguments[0])));
                }
                if (argClazz.equals(File.class.getName())) {
                    return this.serializer.serialize(this.loadExtensionModel((File)this.serializer.deserialize(arguments[0])));
                }
            }
            case "loadExtensionSchema": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                String argClazz = classes[0];
                Preconditions.checkState((classes.length == 1 && (argClazz.equals(ArtifactDescriptor.class.getName()) || argClazz.equals(File.class.getName())) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                if (argClazz.equals(ArtifactDescriptor.class.getName())) {
                    return this.serializer.serialize(this.loadExtensionSchema((ArtifactDescriptor)this.serializer.deserialize(arguments[0])));
                }
                if (argClazz.equals(File.class.getName())) {
                    return this.serializer.serialize(this.loadExtensionSchema((File)this.serializer.deserialize(arguments[0])));
                }
            }
            case "loadMuleExtensionModels": {
                return this.serializer.serialize(this.loadMuleExtensionModels());
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

