/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.cache;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoPool;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorageSerializer;
import org.mule.tooling.client.internal.serialization.KryoFactory;

public class DefaultCacheStorageSerializer
implements MetadataCacheStorageSerializer {
    private KryoPool kryoPool = new KryoPool.Builder(() -> KryoFactory.defaultKryo()).build();

    public void serialize(OutputStream outputStream, Object object) {
        try (Output output = new Output((OutputStream)new BufferedOutputStream(Base64.getEncoder().wrap(outputStream)));){
            this.kryoPool.run(kryo -> {
                kryo.writeClassAndObject(output, object);
                return null;
            });
        }
    }

    public <T> T deserialize(InputStream serialized) {
        try (Input input = new Input((InputStream)new BufferedInputStream(Base64.getDecoder().wrap(serialized)));){
            Object object = this.kryoPool.run(kryo -> kryo.readClassAndObject(input));
            return (T)object;
        }
    }
}

