/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.serialization;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.serialization.TypeAnnotationMapReader;
import org.mule.tooling.client.internal.serialization.TypeAnnotationMapWriter;
import org.mule.tooling.client.internal.serialization.XStreamFactory;
import org.mule.tooling.client.internal.serialization.XmlArtifactDeserializationRequestConverter;

public class XStreamServerSerializer
implements Serializer {
    public static String NAME = "xStream";
    private ClassLoader targetClassLoader;
    private List<Class> typeAnnotationsNotSupportedByToolingRuntimeClient;

    public XStreamServerSerializer(ClassLoader targetClassLoader) {
        this.targetClassLoader = targetClassLoader;
        this.typeAnnotationsNotSupportedByToolingRuntimeClient = Collections.synchronizedList(new ArrayList());
    }

    private static XStream createXStream(ClassLoader targetClassLoader, List<Class> typeAnnotationsNotsupportedByToolingRuntimeClient) {
        XStream xStream = XStreamFactory.createXStream();
        xStream.registerConverter((Converter)new TypeAnnotationsMapConverter(targetClassLoader, typeAnnotationsNotsupportedByToolingRuntimeClient, xStream.getMapper()));
        xStream.registerConverter((Converter)new XmlArtifactDeserializationRequestConverter(xStream.getMapper()));
        xStream.ignoreUnknownElements();
        return xStream;
    }

    public String serialize(Object object) {
        return XStreamServerSerializer.createXStream(this.targetClassLoader, this.typeAnnotationsNotSupportedByToolingRuntimeClient).toXML(object);
    }

    public <T> T deserialize(String content) {
        return (T)XStreamServerSerializer.createXStream(this.targetClassLoader, this.typeAnnotationsNotSupportedByToolingRuntimeClient).fromXML(content);
    }

    private static class TypeAnnotationsMapConverter
    extends MapConverter {
        private TypeAnnotationMapWriter typeAnnotationMapWriter;
        private TypeAnnotationMapReader typeAnnotationMapReader;

        public TypeAnnotationsMapConverter(ClassLoader targetClassLoader, List<Class> typeAnnotationsNotSupportedByToolingRuntimeClient, Mapper mapper) {
            super(mapper);
            this.typeAnnotationMapWriter = new TypeAnnotationMapWriter(targetClassLoader, typeAnnotationsNotSupportedByToolingRuntimeClient);
            this.typeAnnotationMapReader = new TypeAnnotationMapReader();
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            super.marshal((Object)this.typeAnnotationMapWriter.write((Map)source), writer, context);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Map output = (Map)super.unmarshal(reader, context);
            return this.typeAnnotationMapReader.read(output);
        }
    }
}

