/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.session;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.metadata.api.locator.ComponentLocator;
import org.mule.tooling.client.api.cache.CacheStorageSerializer;
import org.mule.tooling.client.api.declaration.session.DeclarationSessionCacheService;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.metadata.ToolingCacheIdGenerator;
import org.mule.tooling.client.internal.serialization.Serializer;

public class DefaultDeclarationSessionCacheService
implements DeclarationSessionCacheService,
Command {
    private final CacheStorageSerializer serializer;
    private final Serializer internalSerializer;
    private final ToolingCacheIdGenerator<ElementDeclaration> cacheIdGenerator;
    private final Map<String, ?> cacheStorage;
    private final ComponentLocator<ElementDeclaration> componentLocator;

    public DefaultDeclarationSessionCacheService(CacheStorageSerializer serializer, Serializer internalSerializer, ToolingCacheIdGenerator<ElementDeclaration> cacheIdGenerator, Map<String, ?> cacheStorage, ComponentLocator<ElementDeclaration> componentLocator) {
        this.serializer = serializer;
        this.internalSerializer = internalSerializer;
        this.cacheIdGenerator = cacheIdGenerator;
        this.cacheStorage = cacheStorage;
        this.componentLocator = componentLocator;
    }

    public CacheStorageSerializer getSerializer() {
        return this.serializer;
    }

    public void invalidateDependencies(String globalElementName) {
        if (this.cacheIsPresent()) {
            Optional configDeclaration = this.componentLocator.get(Location.builderFromStringRepresentation((String)globalElementName).build());
            if (!configDeclaration.isPresent()) {
                throw new ToolingException(String.format("Could not find global element with name: %s", globalElementName));
            }
            Optional connectionDeclaration = ((ConfigurationElementDeclaration)configDeclaration.get()).getConnection();
            ImmutableSet.Builder parentIds = ImmutableSet.builder();
            this.cacheIdGenerator.getIdForGlobalMetadata((ElementDeclaration)configDeclaration.get()).ifPresent(key -> parentIds.add(key));
            this.cacheIdGenerator.getIdForResolvedValuesDependency((ElementDeclaration)configDeclaration.get()).ifPresent(key -> parentIds.add(key));
            connectionDeclaration.ifPresent(connectionElementDeclaration -> this.cacheIdGenerator.getIdForResolvedValuesDependency((ElementDeclaration)connectionElementDeclaration).ifPresent(key -> parentIds.add(key)));
            this.removeRelated((Set<String>)parentIds.build());
        }
    }

    private void removeRelated(Set<String> parentIds) {
        this.cacheStorage.keySet().removeIf(k -> parentIds.stream().filter(p -> k.contains((CharSequence)p)).findAny().isPresent());
    }

    private boolean cacheIsPresent() {
        return this.cacheStorage != null;
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "getSerializer": {
                return this.getSerializer();
            }
            case "invalidateDependencies": {
                this.validateInput(arguments, classes, new Class[]{String.class});
                this.invalidateDependencies((String)this.internalSerializer.deserialize(arguments[0]));
                return null;
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

