/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.session;

import java.util.function.Function;
import javax.validation.ValidationException;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.session.factory.RemoteDeclarationSessionDeployment;
import org.mule.tooling.client.internal.session.factory.RemoteDeclarationSessionProvider;

public class RemoteSessionExecutor {
    private final RemoteDeclarationSessionProvider remoteDeclarationSessionProvider;

    public RemoteSessionExecutor(RemoteDeclarationSessionProvider remoteDeclarationSessionProvider) {
        this.remoteDeclarationSessionProvider = remoteDeclarationSessionProvider;
    }

    public <T> T withRemoteDeclarationSession(Function<String, T> onSuccess, Function<Exception, T> onError) {
        RemoteDeclarationSessionDeployment declarationSessionDeployment = this.remoteDeclarationSessionProvider.getRemoteDeclarationSession();
        if (!declarationSessionDeployment.isSuccess()) {
            Exception exception = declarationSessionDeployment.getException();
            if (exception instanceof ValidationException) {
                return onError.apply(exception);
            }
            if (exception instanceof ToolingException) {
                throw (ToolingException)((Object)exception);
            }
            throw new ToolingException((Throwable)exception);
        }
        return onSuccess.apply(declarationSessionDeployment.getId());
    }
}

