/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfigurationLoader;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolingClassLoaderConfigurationLoader
implements ClassLoaderConfigurationLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolingClassLoaderConfigurationLoader.class);
    private List<ClassLoaderConfigurationLoader> classLoaderConfigurationLoaders;

    public ToolingClassLoaderConfigurationLoader(List<ClassLoaderConfigurationLoader> classLoaderConfigurationLoaders) {
        this.classLoaderConfigurationLoaders = classLoaderConfigurationLoaders;
    }

    public String getId() {
        return "mule";
    }

    public ClassLoaderConfiguration load(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType) throws InvalidDescriptorLoaderException {
        long startTime = System.nanoTime();
        for (ClassLoaderConfigurationLoader classLoaderConfigurationLoader : this.classLoaderConfigurationLoaders) {
            if (!classLoaderConfigurationLoader.supportsArtifactType(artifactType)) continue;
            ClassLoaderConfiguration classLoaderConfiguration = (ClassLoaderConfiguration)classLoaderConfigurationLoader.load(artifactFile, attributes, artifactType);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("ClassLoaderConfiguration for {} loaded in {}ms", (Object)artifactFile.getName(), (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
            }
            return classLoaderConfiguration;
        }
        throw new IllegalStateException(String.format("Artifact type %s not supported", artifactType));
    }

    public boolean supportsArtifactType(ArtifactType artifactType) {
        return this.classLoaderConfigurationLoaders.stream().filter(classLoaderConfigurationLoader -> classLoaderConfigurationLoader.supportsArtifactType(artifactType)).findFirst().isPresent();
    }
}

