/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.session.validation;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.module.extension.internal.value.ValueProviderUtils;
import org.mule.tooling.client.internal.session.validation.ComponentValidationContext;
import org.mule.tooling.client.internal.session.validation.SessionCallValidationException;
import org.mule.tooling.client.internal.session.validation.Validators;

public abstract class AbstractActingParametersValidator
implements Validators.ComponentValidator {
    @Override
    public void validate(ComponentValidationContext<?> context) throws SessionCallValidationException {
        Set mandatoryActingParameterNames = this.doGetActingParameters(context).stream().filter(ActingParameterModel::isRequired).map(ActingParameterModel::getExtractionExpression).map(ValueProviderUtils::getParameterNameFromExtractionExpression).collect(Collectors.toSet());
        Set parametersWithDefaultValue = context.getParameterizedModel().getAllParameterModels().stream().filter(p -> !p.isRequired() && p.getDefaultValue() != null).map(NamedObject::getName).collect(Collectors.toSet());
        Map<String, ParameterValue> populatedParameters = context.getComponentDeclaration().getParameterGroups().stream().flatMap(g -> g.getParameters().stream()).collect(Collectors.toMap(ElementDeclaration::getName, ParameterElementDeclaration::getValue));
        List missingRequiredParameters = mandatoryActingParameterNames.stream().filter(p -> !parametersWithDefaultValue.contains(p)).filter(rp -> !populatedParameters.containsKey(rp) || populatedParameters.get(rp) == null).collect(Collectors.toList());
        if (!missingRequiredParameters.isEmpty()) {
            throw new SessionCallValidationException(String.format("%s, the parameters %s are missing from the declaration", this.getErrorMessagePrefix(context), missingRequiredParameters), "Missing required parameters", "MISSING_REQUIRED_PARAMETERS");
        }
    }

    protected abstract String getErrorMessagePrefix(ComponentValidationContext<?> var1);

    protected abstract List<ActingParameterModel> doGetActingParameters(ComponentValidationContext<?> var1);
}

