/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.mule.tooling.client.api.datasense.ImmutableMetadataCacheKeyInfo;
import org.mule.tooling.client.api.datasense.MetadataCache;
import org.mule.tooling.client.api.exception.ToolingException;
import org.slf4j.MDC;

public class MetadataCacheProxy
implements MetadataCache {
    private Object proxyTarget;

    public MetadataCacheProxy(Object proxyTarget) {
        Objects.requireNonNull(proxyTarget, "proxyTarget cannot be null");
        this.proxyTarget = proxyTarget;
    }

    public Serializable invoke(String methodName, String componentId, String location, Long timestamp, Map<String, String> toolingArtifactProperties, Callable callable) {
        try {
            Method method = this.proxyTarget.getClass().getMethod(methodName, this.proxyTarget.getClass().getClassLoader().loadClass(MetadataCache.MetadataCacheKeyInfo.class.getName()), Callable.class);
            method.setAccessible(true);
            CallableProxy proxyCallable = new CallableProxy(callable);
            return (Serializable)method.invoke(this.proxyTarget, this.createMetadataCacheKeyInfo(componentId, location, timestamp, toolingArtifactProperties), proxyCallable);
        }
        catch (Exception e) {
            throw new ToolingException("Error while calling proxy method on client code", (Throwable)e);
        }
    }

    private Object createMetadataCacheKeyInfo(String componentId, String location, Long timestamp, Map<String, String> toolingArtifactProperties) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        ClassLoader classLoader = this.proxyTarget.getClass().getClassLoader();
        classLoader.loadClass(MDC.class.getName()).getMethod("setContextMap", Map.class).invoke(null, MDC.getCopyOfContextMap());
        return classLoader.loadClass(ImmutableMetadataCacheKeyInfo.class.getName()).getConstructor(String.class, String.class, Long.class, Map.class).newInstance(componentId, location, timestamp, toolingArtifactProperties);
    }

    public Serializable getOperationMetadata(MetadataCache.MetadataCacheKeyInfo metadataCacheKeyInfo, Callable resolver) {
        return this.invoke("getOperationMetadata", metadataCacheKeyInfo.getComponentId(), metadataCacheKeyInfo.getLocation(), metadataCacheKeyInfo.getTimestamp(), metadataCacheKeyInfo.getToolingArtifactProperties(), resolver);
    }

    public Serializable getSourceMetadata(MetadataCache.MetadataCacheKeyInfo metadataCacheKeyInfo, Callable<MetadataCache.MetadataResult> resolver) {
        return this.invoke("getSourceMetadata", metadataCacheKeyInfo.getComponentId(), metadataCacheKeyInfo.getLocation(), metadataCacheKeyInfo.getTimestamp(), metadataCacheKeyInfo.getToolingArtifactProperties(), resolver);
    }

    public Serializable getMetadataKeys(MetadataCache.MetadataCacheKeyInfo metadataCacheKeyInfo, Callable<MetadataCache.MetadataResult> resolver) {
        return this.invoke("getMetadataKeys", metadataCacheKeyInfo.getComponentId(), metadataCacheKeyInfo.getLocation(), metadataCacheKeyInfo.getTimestamp(), metadataCacheKeyInfo.getToolingArtifactProperties(), resolver);
    }

    private class CallableProxy
    implements Callable {
        private Callable proxyTarget;

        public CallableProxy(Callable proxyTarget) {
            this.proxyTarget = proxyTarget;
        }

        public Object call() throws Exception {
            return this.proxyTarget.call();
        }
    }
}

