/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.session.mediator.resolver;

import org.jetbrains.annotations.NotNull;
import org.mule.tooling.client.api.value.resolver.ValueResolverFailure;
import org.mule.tooling.client.api.value.resolver.ValueResolverResult;
import org.mule.tooling.client.internal.session.mediator.resolver.SessionFunction;

public abstract class SkeletalValueResolver<T> {
    protected static final String INVALID_ACTING_PARAMETER_VALUES = "INVALID_ACTING_PARAMETER_VALUES";
    protected static final String MISSING_REQUIRED_PARAMETERS = "MISSING_REQUIRED_PARAMETERS";
    protected final SessionFunction<T> sessionFunction;
    protected final boolean ignoreCache;

    protected SkeletalValueResolver(SessionFunction<T> sessionFunction, boolean ignoreCache) {
        this.ignoreCache = ignoreCache;
        this.sessionFunction = sessionFunction;
    }

    @NotNull
    protected ValueResolverResult invalidActingParameterFailure(String invalidParameter, String reason) {
        return ValueResolverResult.failure((ValueResolverFailure)new ValueResolverFailure(String.format("Acting parameters have values that are not valid: ['%s']", invalidParameter), reason, INVALID_ACTING_PARAMETER_VALUES));
    }

    @NotNull
    protected ValueResolverResult unknownActingParametersFailure(String invalidParameter, String invalidValue) {
        return ValueResolverResult.failure((ValueResolverFailure)new ValueResolverFailure(String.format("Acting parameters have unknown values: ['%s':%s]", invalidParameter, invalidValue), "The values assigned to acting parameters represent unknown options", INVALID_ACTING_PARAMETER_VALUES));
    }

    @NotNull
    protected ValueResolverResult missingActingParametersFailure(String missingParameter) {
        return ValueResolverResult.failure((ValueResolverFailure)new ValueResolverFailure(String.format("There are missing acting parameters: ['%s']", missingParameter), "Acting parameters required for the resolution are missing", MISSING_REQUIRED_PARAMETERS));
    }
}

