/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.values;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.tooling.client.internal.metadata.ToolingCacheIdGenerator;
import org.mule.tooling.client.internal.utils.FunctionalUtils;
import org.mule.tooling.client.internal.values.ValueProviderCache;

public class DefaultValueProviderCache
implements ValueProviderCache {
    private final Map<String, ValueResult> storage;
    private final ToolingCacheIdGenerator<ComponentAst> cacheIdGenerator;

    public DefaultValueProviderCache(Map<String, ValueResult> storage, ToolingCacheIdGenerator<ComponentAst> cacheIdGenerator) {
        this.storage = storage;
        this.cacheIdGenerator = cacheIdGenerator;
    }

    @Override
    public ValueResult getValues(ComponentAst componentAst, String parameterName, Callable<ValueResult> callable) {
        return this.cacheIdGenerator.getIdForResolvedValues(componentAst, parameterName).map(id -> this.storage.computeIfAbsent((String)id, k -> FunctionalUtils.executeHandling(callable, e -> ValueResult.resultFrom((ResolvingFailure)ResolvingFailure.Builder.newFailure((Throwable)e).build())))).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't create a value provider cache id for component: %s", componentAst.getLocation())));
    }

    @Override
    public void dispose(ComponentAst componentAst, List<String> parameterNames) {
        List<String> allParameters = parameterNames.isEmpty() ? this.collectAllProvidedParameterNames(componentAst) : parameterNames;
        allParameters.forEach(p -> this.cacheIdGenerator.getIdForResolvedValues(componentAst, (String)p).ifPresent(id -> this.storage.keySet().remove(id)));
    }

    private List<String> collectAllProvidedParameterNames(ComponentAst componentAst) {
        return componentAst.getModel(ParameterizedModel.class).map(m -> m.getAllParameterModels().stream().filter(p -> p.getValueProviderModel().isPresent()).map(p -> ((ValueProviderModel)p.getValueProviderModel().get()).getProviderName()).collect(Collectors.toList())).orElse(Collections.emptyList());
    }
}

