/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.session.mediator.resolver;

import java.util.Collections;
import java.util.Set;
import org.mule.runtime.api.meta.model.parameter.FieldValueProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.tooling.client.api.value.resolver.ValueResolverResult;
import org.mule.tooling.client.internal.session.cache.DeclarationValueProviderCache;
import org.mule.tooling.client.internal.session.filter.FieldValueFilter;
import org.mule.tooling.client.internal.session.filter.exception.InvalidLevelValueException;
import org.mule.tooling.client.internal.session.filter.exception.MissingLevelException;
import org.mule.tooling.client.internal.session.filter.exception.UnknownLevelValueException;
import org.mule.tooling.client.internal.session.mediator.resolver.SessionFunction;
import org.mule.tooling.client.internal.session.mediator.resolver.SkeletalValueResolver;
import org.mule.tooling.client.internal.session.mediator.resolver.ValuesResolver;
import org.mule.tooling.client.internal.utils.ValueResolverUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldValueProviderResolver
extends SkeletalValueResolver<ValueResult>
implements ValuesResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldValueProviderResolver.class);
    private final ParameterizedElementDeclaration elementDeclaration;
    private final FieldValueProviderModel fieldValueProviderModel;
    private final DeclarationValueProviderCache valueProviderCache;
    private final FieldValueFilter fieldValueFilter;

    public FieldValueProviderResolver(SessionFunction<ValueResult> sessionFunction, boolean ignoreCache, ParameterizedElementDeclaration elementDeclaration, FieldValueProviderModel fieldValueProviderModel, DeclarationValueProviderCache valueProviderCache, FieldValueFilter fieldValueFilter) {
        super(sessionFunction, ignoreCache);
        this.elementDeclaration = elementDeclaration;
        this.fieldValueProviderModel = fieldValueProviderModel;
        this.valueProviderCache = valueProviderCache;
        this.fieldValueFilter = fieldValueFilter;
    }

    @Override
    public ValueResolverResult resolve(ParameterizedModel parameterizedModel, ParameterModel parameterModel, String parameterName) {
        Set<Value> requestedLevelValues;
        block6: {
            ValueResult values;
            String targetSelector = this.fieldValueProviderModel.getTargetSelector();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolving values using FieldValueProvider mechanism for parameter: '{}' with targetSelector: '{}' using providerName: '{}' on element: '{}' for declared for extension: '{}'", new Object[]{parameterName, targetSelector, parameterName, this.elementDeclaration.getName(), this.elementDeclaration.getDeclaringExtension()});
            }
            if (!(values = this.valueProviderCache.getValues((ElementDeclaration)this.elementDeclaration, parameterName, targetSelector, () -> (ValueResult)this.sessionFunction.apply((runtimeToolingService, id) -> runtimeToolingService.getFieldValues(id, this.elementDeclaration, parameterName, targetSelector)), this.ignoreCache)).isSuccess()) {
                return ValueResolverUtils.toValueResolverResult(values);
            }
            requestedLevelValues = Collections.emptySet();
            try {
                requestedLevelValues = this.fieldValueFilter.filter(this.fieldValueProviderModel, parameterModel, this.elementDeclaration, values.getValues());
            }
            catch (MissingLevelException e) {
                return this.missingActingParametersFailure(e.getMissingParameterName());
            }
            catch (InvalidLevelValueException e) {
                return this.invalidActingParameterFailure(e.getTargetSelector(), e.getMessage());
            }
            catch (UnknownLevelValueException e) {
                if (this.fieldValueProviderModel.isOpen() || this.fieldValueProviderModel.getPartOrder() <= 1) break block6;
                return this.unknownActingParametersFailure(e.getParameterName(), e.getParameterValue());
            }
        }
        return ValueResolverResult.success(ValueResolverUtils.toResolvedValues(requestedLevelValues));
    }
}

