/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.internal.application.AbstractArtifactDeployer;
import org.mule.tooling.client.internal.application.ArtifactResources;

public class FileSystemArtifactDeployer
extends AbstractArtifactDeployer {
    private Function<AbstractArtifactDeployer.DeploymentContext, String> deployFunction;
    private Consumer<AbstractArtifactDeployer.DeploymentContext> disposeFunction;

    public FileSystemArtifactDeployer(ArtifactResources artifactResources, Supplier<RuntimeToolingService> runtimeToolingService, Map<String, String> deploymentProperties) {
        super(artifactResources, runtimeToolingService, deploymentProperties);
        if (artifactResources.getArtifactType().equals((Object)ArtifactType.DOMAIN)) {
            this.deployFunction = deploymentContext -> {
                if (deploymentContext.getLocalLocation() != null) {
                    return deploymentContext.getRuntimeToolingService().deployDomain(deploymentContext.getArtifactId(), deploymentContext.getLocalLocation(), deploymentContext.getDeploymentProperties());
                }
                return deploymentContext.getRuntimeToolingService().deployDomain(deploymentContext.getArtifactId(), deploymentContext.getContent(), deploymentContext.getDeploymentProperties());
            };
            this.disposeFunction = deploymentContext -> deploymentContext.getRuntimeToolingService().disposeDomain(deploymentContext.getArtifactId());
        } else {
            this.deployFunction = deploymentContext -> {
                if (deploymentContext.getDomainId() != null) {
                    if (deploymentContext.getLocalLocation() != null) {
                        return deploymentContext.getRuntimeToolingService().deployApplication(deploymentContext.getArtifactId(), deploymentContext.getLocalLocation(), deploymentContext.getDomainId(), deploymentContext.getDeploymentProperties());
                    }
                    return deploymentContext.getRuntimeToolingService().deployApplication(deploymentContext.getArtifactId(), deploymentContext.getContent(), deploymentContext.getDomainId(), deploymentContext.getDeploymentProperties());
                }
                if (deploymentContext.getLocalLocation() != null) {
                    return deploymentContext.getRuntimeToolingService().deployApplication(deploymentContext.getArtifactId(), deploymentContext.getLocalLocation(), deploymentContext.getDeploymentProperties());
                }
                return deploymentContext.getRuntimeToolingService().deployApplication(deploymentContext.getArtifactId(), deploymentContext.getContent(), deploymentContext.getDeploymentProperties());
            };
            this.disposeFunction = deploymentContext -> deploymentContext.getRuntimeToolingService().disposeApplication(deploymentContext.getArtifactId());
        }
    }

    @Override
    protected String doInternalDeploy(ArtifactResources artifactResources, RuntimeToolingService runtimeToolingService, String domainId, Map<String, String> deploymentProperties) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Deploying application from: {}", (Object)artifactResources);
        }
        return this.deployFunction.apply(new AbstractArtifactDeployer.DeploymentContext((AbstractArtifactDeployer)this, artifactResources.getArtifactId(), artifactResources.getRootArtifactFile(), domainId, deploymentProperties, runtimeToolingService));
    }

    @Override
    protected void doInternalDispose(String id, RuntimeToolingService runtimeToolingService) {
        this.disposeFunction.accept(new AbstractArtifactDeployer.DeploymentContext(this, id, runtimeToolingService));
    }
}

