/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.metadata;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoPool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.mule.datasense.enrichment.model.IdComponentModelSelector;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.tooling.client.api.datasense.ImmutableMetadataCacheKeyInfo;
import org.mule.tooling.client.api.datasense.ImmutableMetadataResult;
import org.mule.tooling.client.api.datasense.MetadataCache;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.MetadataPartsFactory;
import org.mule.tooling.client.internal.metadata.MetadataCache;
import org.mule.tooling.client.internal.serialization.KryoFactory;

public class LegacyToolingMetadataCache
implements MetadataCache {
    public static final String TIMESTAMP = "timestamp";
    private final LazyValue<ArtifactAst> artifactAstLazyValue;
    private final Map<String, String> toolingArtifactProperties;
    private final org.mule.tooling.client.api.datasense.MetadataCache delegate;
    private final KryoPool kryoPool;

    public LegacyToolingMetadataCache(LazyValue<ArtifactAst> artifactAstLazyValue, Map<String, String> toolingArtifactProperties, org.mule.tooling.client.api.datasense.MetadataCache delegate) {
        this.artifactAstLazyValue = artifactAstLazyValue;
        this.toolingArtifactProperties = toolingArtifactProperties;
        this.delegate = delegate;
        this.kryoPool = new KryoPool.Builder(() -> KryoFactory.defaultKryo()).build();
    }

    @Override
    public MetadataResult<OperationModel> getOperationMetadata(ComponentAst componentAst, Callable<MetadataResult<OperationModel>> resolver) {
        return (MetadataResult)this.deserialize((String)((Object)this.delegate.getOperationMetadata((MetadataCache.MetadataCacheKeyInfo)new ImmutableMetadataCacheKeyInfo(this.getComponentId(componentAst), componentAst.getLocation().getLocation(), this.resolveEffectiveTimestamp(componentAst), this.toolingArtifactProperties), () -> {
            MetadataResult result = (MetadataResult)resolver.call();
            List<Object> failures = Collections.emptyList();
            if (!result.isSuccess()) {
                failures = MetadataPartsFactory.toMetadataFailuresDTO(result.getFailures());
            }
            return new ImmutableMetadataResult(Boolean.valueOf(result.isSuccess()), (Serializable)((Object)this.serialize(result)), failures);
        })));
    }

    @Override
    public MetadataResult<SourceModel> getSourceMetadata(ComponentAst componentAst, Callable<MetadataResult<SourceModel>> resolver) {
        return (MetadataResult)this.deserialize((String)((Object)this.delegate.getSourceMetadata((MetadataCache.MetadataCacheKeyInfo)new ImmutableMetadataCacheKeyInfo(this.getComponentId(componentAst), componentAst.getLocation().getLocation(), this.resolveEffectiveTimestamp(componentAst), this.toolingArtifactProperties), () -> {
            MetadataResult result = (MetadataResult)resolver.call();
            List<Object> failures = Collections.emptyList();
            if (!result.isSuccess()) {
                failures = MetadataPartsFactory.toMetadataFailuresDTO(result.getFailures());
            }
            return new ImmutableMetadataResult(Boolean.valueOf(result.isSuccess()), (Serializable)((Object)this.serialize(result)), failures);
        })));
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeys(ComponentAst componentAst, Callable<MetadataResult<MetadataKeysContainer>> resolver) {
        return (MetadataResult)this.deserialize((String)((Object)this.delegate.getMetadataKeys((MetadataCache.MetadataCacheKeyInfo)new ImmutableMetadataCacheKeyInfo(this.getComponentId(componentAst), componentAst.getLocation().getLocation(), this.resolveEffectiveTimestamp(componentAst), this.toolingArtifactProperties), () -> {
            MetadataResult result = (MetadataResult)resolver.call();
            List<Object> failures = Collections.emptyList();
            if (!result.isSuccess()) {
                failures = MetadataPartsFactory.toMetadataFailuresDTO(result.getFailures());
            }
            return new ImmutableMetadataResult(Boolean.valueOf(result.isSuccess()), (Serializable)((Object)this.serialize(result)), failures);
        })));
    }

    @Override
    public void dispose(ComponentAst componentAst) {
    }

    @Override
    public void invalidateMetadataKeysFor(ComponentAst componentAst) {
    }

    private String serialize(Object object) {
        String string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            try (Output output = new Output((OutputStream)byteArrayOutputStream);){
                this.kryoPool.run(kryo -> {
                    kryo.writeClassAndObject(output, object);
                    return null;
                });
            }
            string = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ToolingException("Error while creating object from serialization", (Throwable)e);
            }
        }
        byteArrayOutputStream.close();
        return string;
    }

    private <T> T deserialize(String content) {
        try (Input input = new Input((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(content)));){
            Object object = this.kryoPool.run(kryo -> kryo.readClassAndObject(input));
            return (T)object;
        }
    }

    private Optional<Long> resolveTimestamp(ComponentAst componentAst) {
        if (componentAst == null) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(Long.parseLong((String)componentAst.getMetadata().getDocAttributes().get(TIMESTAMP)));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    private Optional<String> getConfigurationRef(ComponentAst componentAst) {
        ComponentParameterAst componentAstParameter = componentAst.getParameter("General", "config-ref");
        if (componentAstParameter == null) {
            return Optional.empty();
        }
        return componentAstParameter.getValue().getValue();
    }

    private String getComponentId(ComponentAst componentAst) {
        return IdComponentModelSelector.getComponentId((ComponentAst)componentAst);
    }

    private Long resolveEffectiveTimestamp(ComponentAst componentAst) {
        Long componentTimestamp = this.resolveTimestamp(componentAst).orElse(null);
        Optional relatedConfigurationOptional = this.getConfigurationRef(componentAst).flatMap(globalElementName -> ((ArtifactAst)this.artifactAstLazyValue.get()).topLevelComponentsStream().filter(topLevelComponentAst -> globalElementName.equals(topLevelComponentAst.getComponentId().orElse(null))).findAny());
        if (relatedConfigurationOptional.isPresent()) {
            Long configurationTimestamp = this.resolveTimestamp((ComponentAst)relatedConfigurationOptional.get()).orElse(null);
            return componentTimestamp != null && configurationTimestamp != null ? Long.valueOf(Long.max(componentTimestamp, configurationTimestamp)) : null;
        }
        return componentTimestamp;
    }
}

