/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.session.mediator;

import java.util.Optional;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclarationVisitor;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.extension.api.property.ResolverInformation;
import org.mule.runtime.extension.api.property.TypeResolversInformationModelProperty;
import org.mule.tooling.client.api.value.resolver.ValueResolverFailure;
import org.mule.tooling.client.api.value.resolver.ValueResolverResult;
import org.mule.tooling.client.internal.session.ConfigurationDeclarationProvider;
import org.mule.tooling.client.internal.session.mediator.resolver.ValuesResolverFactory;
import org.mule.tooling.client.internal.session.validation.ConnectionAndConfigurationValidator;
import org.mule.tooling.client.internal.session.validation.ParameterExistsValidator;
import org.mule.tooling.client.internal.session.validation.SessionCallValidationException;
import org.mule.tooling.client.internal.session.validation.SessionCallValidator;
import org.mule.tooling.client.internal.session.validation.Validators;
import org.mule.tooling.client.internal.session.validation.ValueProviderActingParametersValidator;

public class ValuesResolverModelMediator {
    private final ConfigurationDeclarationProvider configurationDeclarationProvider;
    private final SessionCallValidator sessionCallValidator;
    private final ParameterizedElementDeclaration parameterizedElementDeclaration;
    private final String parameterName;
    private final ValueResolverResult failure;
    private Reference<ParameterizedModel> parameterizedModel = new Reference();
    private Reference<ParameterModel> parameterModel = new Reference();
    private ComponentElementDeclaration<?> componentElementDeclaration;
    private ValueProviderModel valueProviderModel;
    private MetadataKeyPartModelProperty metadataKeyPartModelProperty;

    public ValuesResolverModelMediator(ConfigurationDeclarationProvider configurationDeclarationProvider, ParameterizedElementDeclaration elementDeclaration, SessionCallValidator sessionCallValidator, String parameterName) {
        this.configurationDeclarationProvider = configurationDeclarationProvider;
        this.parameterizedElementDeclaration = elementDeclaration;
        this.parameterName = parameterName;
        this.sessionCallValidator = sessionCallValidator;
        this.failure = this.validateModel();
    }

    public ValueResolverResult resolve(ValuesResolverFactory valuesResolverFactory, boolean ignoreCache) {
        if (this.failure != null) {
            return this.failure;
        }
        if (this.isValueProviderResolver()) {
            return valuesResolverFactory.createValueProviderResolver(this.parameterizedElementDeclaration, this.valueProviderModel, ignoreCache).resolve((ParameterizedModel)this.parameterizedModel.get(), (ParameterModel)this.parameterModel.get(), this.parameterName);
        }
        return valuesResolverFactory.createMetadataKeyResolver(this.componentElementDeclaration, this.metadataKeyPartModelProperty, ignoreCache).resolve((ParameterizedModel)this.parameterizedModel.get(), (ParameterModel)this.parameterModel.get(), this.parameterName);
    }

    private boolean isValueProviderResolver() {
        return this.valueProviderModel != null;
    }

    private ValueResolverResult validateModel() {
        try {
            Reference requiresConfig = new Reference((Object)false);
            Reference requiresConnection = new Reference((Object)false);
            Validators.ComponentValidator[] componentValidatorArray = new Validators.ComponentValidator[3];
            componentValidatorArray[0] = c -> {
                this.parameterizedModel.set((Object)c.getParameterizedModel());
                ParameterExistsValidator parameterExistsValidator = new ParameterExistsValidator(this.parameterName);
                parameterExistsValidator.validate(c);
                this.parameterModel.set((Object)parameterExistsValidator.getParameterModel());
                if (((ParameterModel)this.parameterModel.get()).getValueProviderModel().isPresent()) {
                    this.valueProviderModel = (ValueProviderModel)((ParameterModel)this.parameterModel.get()).getValueProviderModel().get();
                    requiresConfig.set((Object)this.valueProviderModel.requiresConfiguration());
                    requiresConnection.set((Object)this.valueProviderModel.requiresConnection());
                } else {
                    Optional metadataKeyPartModelProperty = ((ParameterModel)this.parameterModel.get()).getModelProperty(MetadataKeyPartModelProperty.class);
                    if (!metadataKeyPartModelProperty.isPresent()) {
                        throw new SessionCallValidationException(String.format("Parameter: '%s' on element : '%s' for extension: '%s' is not marked as MetadataKeyPartModelProperty and doesn't have a ValueProvider defined", this.parameterName, this.parameterizedElementDeclaration.getName(), this.parameterizedElementDeclaration.getDeclaringExtension()), "ParameterModel doesn't support values resolution", "INVALID_PARAMETER");
                    }
                    this.metadataKeyPartModelProperty = (MetadataKeyPartModelProperty)metadataKeyPartModelProperty.get();
                    ComponentParameterizedElementDeclarationVisitor componentParameterizedElementDeclarationVisitor = new ComponentParameterizedElementDeclarationVisitor();
                    this.parameterizedElementDeclaration.accept((ParameterizedElementDeclarationVisitor)componentParameterizedElementDeclarationVisitor);
                    if (!componentParameterizedElementDeclarationVisitor.getComponentElement().isPresent()) {
                        throw new SessionCallValidationException(String.format("Parameter: '%s' on element : '%s' for extension: '%s' is marked as MetadataKeyPartModelProperty but declaration is not a ComponentElementDeclaration. Only ComponentElementDeclaration could support metadata keys.", this.parameterName, this.parameterizedElementDeclaration.getName(), this.parameterizedElementDeclaration.getDeclaringExtension()), "ParameterModel doesn't support values resolution", "INVALID_PARAMETER");
                    }
                    this.componentElementDeclaration = componentParameterizedElementDeclarationVisitor.getComponentElement().get();
                    EnrichableModel enrichableModel = c.getEnrichableModel();
                    Optional keyResolverInfo = enrichableModel.getModelProperty(TypeResolversInformationModelProperty.class).flatMap(TypeResolversInformationModelProperty::getKeysResolver);
                    if (!keyResolverInfo.isPresent()) {
                        throw new SessionCallValidationException(String.format("Parameter: '%s' on element : '%s' for extension: '%s' is marked as MetadataKeyPartModelProperty but Component does not have any KeyResolverInformation", this.parameterName, this.parameterizedElementDeclaration.getName(), this.parameterizedElementDeclaration.getDeclaringExtension()), "ParameterizedModel does not have KeyResolverInformation", "INVALID_ELEMENT");
                    }
                    requiresConfig.set((Object)((ResolverInformation)keyResolverInfo.get()).isRequiresConfiguration());
                    requiresConnection.set((Object)((ResolverInformation)keyResolverInfo.get()).isRequiresConnection());
                }
            };
            componentValidatorArray[1] = new ValueProviderActingParametersValidator(this.parameterName);
            componentValidatorArray[2] = new ConnectionAndConfigurationValidator(this.parameterizedElementDeclaration, this.configurationDeclarationProvider, () -> ((Reference)requiresConnection).get(), () -> ((Reference)requiresConfig).get(), () -> String.format("Parameter: '%s' on element : '%s' for extension: '%s'", this.parameterName, this.parameterizedElementDeclaration.getName(), this.parameterizedElementDeclaration.getDeclaringExtension()));
            this.sessionCallValidator.validateComponent(this.parameterizedElementDeclaration, componentValidatorArray);
        }
        catch (SessionCallValidationException e) {
            return ValueResolverResult.failure((ValueResolverFailure)new ValueResolverFailure(e.getMessage(), e.getReason(), e.getFailureCode()));
        }
        return null;
    }

    static class ComponentParameterizedElementDeclarationVisitor
    implements ParameterizedElementDeclarationVisitor {
        private ComponentElementDeclaration<?> componentElementDeclaration;

        ComponentParameterizedElementDeclarationVisitor() {
        }

        public void visitComponentElementDeclaration(ComponentElementDeclaration componentElementDeclaration) {
            this.componentElementDeclaration = componentElementDeclaration;
        }

        public Optional<ComponentElementDeclaration<?>> getComponentElement() {
            return Optional.ofNullable(this.componentElementDeclaration);
        }
    }
}

