/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.session.filter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.meta.model.parameter.FieldValueProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.module.extension.internal.loader.utils.FieldValueProviderNameUtils;
import org.mule.runtime.module.tooling.internal.artifact.params.ParameterExtractor;
import org.mule.tooling.client.internal.session.filter.FilterUtils;
import org.mule.tooling.client.internal.session.filter.exception.InvalidLevelValueException;
import org.mule.tooling.client.internal.session.filter.exception.MissingLevelException;
import org.mule.tooling.client.internal.session.filter.exception.UnknownLevelValueException;

public class FieldValueFilter {
    private final ExpressionLanguage expressionLanguage;

    public FieldValueFilter(ExpressionLanguage expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }

    public Set<Value> filter(FieldValueProviderModel fieldValueProviderModel, ParameterModel parameterModel, ParameterizedElementDeclaration parameterizedElementDeclaration, Set<Value> values) {
        BindingContext bindingContext = this.createBindingContext(fieldValueProviderModel, parameterizedElementDeclaration);
        Map<Integer, FieldValueProviderModel> orderedModels = this.orderFieldModels(parameterModel, fieldValueProviderModel);
        HashMap<Integer, Set<Value>> valuesByPartOrder = new HashMap<Integer, Set<Value>>();
        try {
            this.filterValues(valuesByPartOrder, values, orderedModels, bindingContext, 1);
        }
        catch (MissingLevelException e) {
            Set level = (Set)valuesByPartOrder.get(fieldValueProviderModel.getPartOrder());
            if (level == null) {
                throw e;
            }
            return level;
        }
        return Collections.emptySet();
    }

    private Map<Integer, FieldValueProviderModel> orderFieldModels(ParameterModel parameterModel, FieldValueProviderModel requestedModel) {
        return parameterModel.getFieldValueProviderModels().stream().filter(m -> m.getProviderId().equals(requestedModel.getProviderId())).filter(m -> m.getProviderName().equals(requestedModel.getProviderName())).collect(Collectors.toMap(ValueProviderModel::getPartOrder, UnaryOperator.identity()));
    }

    private BindingContext createBindingContext(FieldValueProviderModel fieldValueProviderModel, ParameterizedElementDeclaration parameterizedElementDeclaration) {
        String parameterName = FieldValueProviderNameUtils.getParameterName((FieldValueProviderModel)fieldValueProviderModel);
        BindingContext.Builder bindingContextBuilder = BindingContext.builder();
        FilterUtils.getParameterConfiguredValue(parameterizedElementDeclaration, parameterName).map(ParameterExtractor::asDataWeaveExpression).ifPresent(tv -> bindingContextBuilder.addBinding(this.keywordSafeName(parameterName), tv));
        return bindingContextBuilder.build();
    }

    private void filterValues(Map<Integer, Set<Value>> valuesByPartOrder, Set<Value> values, Map<Integer, FieldValueProviderModel> orderedFieldModels, BindingContext bindingContext, int level) {
        if (!values.stream().findFirst().isPresent()) {
            return;
        }
        valuesByPartOrder.put(level, values);
        this.filterValues(valuesByPartOrder, this.getMatchingValue(values, orderedFieldModels.get(level), bindingContext).getChilds(), orderedFieldModels, bindingContext, level + 1);
    }

    private Value getMatchingValue(Set<Value> values, FieldValueProviderModel fieldModel, BindingContext bindingContext) {
        String parameterName = FieldValueProviderNameUtils.getParameterName((FieldValueProviderModel)fieldModel);
        String keywordSafeProviderName = this.keywordSafeName(parameterName);
        String extractionExpression = parameterName + "." + fieldModel.getTargetSelector();
        String sanitizedExtractionExpression = keywordSafeProviderName + "." + fieldModel.getTargetSelector();
        TypedValue valuePartConfiguredValue = bindingContext.lookup(keywordSafeProviderName).map(tv -> {
            try {
                return this.expressionLanguage.evaluate(sanitizedExtractionExpression, DataType.STRING, bindingContext);
            }
            catch (ExpressionExecutionException e) {
                throw new InvalidLevelValueException(extractionExpression, e);
            }
        }).orElseThrow(() -> new MissingLevelException(parameterName));
        if (valuePartConfiguredValue.getValue() == null) {
            throw new MissingLevelException(extractionExpression);
        }
        if (!String.class.isAssignableFrom(valuePartConfiguredValue.getDataType().getType())) {
            throw new UnknownLevelValueException(extractionExpression, valuePartConfiguredValue.getValue().toString());
        }
        String stringValue = (String)valuePartConfiguredValue.getValue();
        return values.stream().filter(v -> v.getId().equals(stringValue)).findAny().orElseThrow(() -> new UnknownLevelValueException(extractionExpression, stringValue));
    }

    private String keywordSafeName(String parameterName) {
        return parameterName + "_";
    }
}

